/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiUser;
import java.lang.reflect.Type;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.security.ChallengeAuthenticator;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rest.internal.Utils;

public class XWikiAuthentication
extends ChallengeAuthenticator {
    public XWikiAuthentication(Context context) throws IllegalArgumentException {
        super(context, true, ChallengeScheme.CUSTOM, "XWiki");
    }

    public boolean authenticate(Request request, Response response) {
        EntityReferenceSerializer serializer;
        DocumentReferenceResolver resolver;
        if (request.getResourceRef().getPath().endsWith("/browser_authentication")) {
            return super.authenticate(request, response);
        }
        ComponentManager componentManager = (ComponentManager)this.getContext().getAttributes().get("xwikiComponentManager");
        XWikiContext xwikiContext = Utils.getXWikiContext(componentManager);
        XWiki xwiki = Utils.getXWiki(componentManager);
        try {
            resolver = (DocumentReferenceResolver)componentManager.getInstance((Type)DocumentReferenceResolver.TYPE_STRING, "current");
            serializer = (EntityReferenceSerializer)componentManager.getInstance((Type)EntityReferenceSerializer.TYPE_STRING);
        }
        catch (ComponentLookupException e1) {
            return false;
        }
        xwikiContext.setUserReference(null);
        Form responseHeaders = (Form)response.getAttributes().get("org.restlet.http.headers");
        if (responseHeaders == null) {
            responseHeaders = new Form();
            response.getAttributes().put("org.restlet.http.headers", responseHeaders);
        }
        responseHeaders.add("XWiki-User", (String)serializer.serialize((EntityReference)xwikiContext.getUserReference(), new Object[0]));
        responseHeaders.add("XWiki-Version", xwikiContext.getWiki().getVersion());
        try {
            XWikiUser xwikiUser = xwiki.checkAuth(xwikiContext);
            if (xwikiUser != null) {
                xwikiContext.setUserReference(resolver.resolve((Object)xwikiUser.getUser(), new Object[0]));
                this.getLogger().fine(String.format("Authenticated as '%s'.", xwikiUser.getUser()));
                responseHeaders.set("XWiki-User", (String)serializer.serialize((EntityReference)xwikiContext.getUserReference(), new Object[0]));
                return true;
            }
        }
        catch (XWikiException e) {
            this.getLogger().log(Level.WARNING, "Exception occurred while authenticating.", e);
        }
        return super.authenticate(request, response);
    }
}

