/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.pages.PageResource;

public class BaseAttachmentsResource
extends XWikiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachments getAttachments(String wikiName, String name, String page, String space, String author, String types, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        Attachments attachments = this.objectFactory.createAttachments();
        try {
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            HashMap<String, String> filters = new HashMap<String, String>();
            if (!name.equals("")) {
                filters.put("name", name);
            }
            if (!page.equals("")) {
                filters.put("page", name);
            }
            if (!space.equals("")) {
                filters.put("space", Utils.getLocalSpaceId(this.parseSpaceSegments(space)));
            }
            if (!author.equals("")) {
                filters.put("author", author);
            }
            Formatter f = new Formatter();
            f.format("select doc.space, doc.name, doc.version, attachment from XWikiDocument as doc, XWikiAttachment as attachment where (attachment.docId=doc.id ", new Object[0]);
            if (filters.keySet().size() > 0) {
                for (String param : filters.keySet()) {
                    if (param.equals("name")) {
                        f.format(" and upper(attachment.filename) like :name ", new Object[0]);
                    }
                    if (param.equals("page")) {
                        f.format(" and upper(doc.fullName) like :page ", new Object[0]);
                    }
                    if (param.equals("space")) {
                        f.format(" and upper(doc.space) like :space ", new Object[0]);
                    }
                    if (!param.equals("author")) continue;
                    f.format(" and upper(attachment.author) like :author ", new Object[0]);
                }
            }
            f.format(")", new Object[0]);
            String queryString = f.toString();
            List queryResult = null;
            try {
                Query query = this.queryManager.createQuery(queryString, "xwql").setLimit(number.intValue()).setOffset(start.intValue());
                for (String[] param : filters.keySet()) {
                    query.bindValue((String)param, (Object)String.format("%%%s%%", ((String)filters.get(param)).toUpperCase()));
                }
                queryResult = query.execute();
            }
            catch (QueryException e) {
                throw new XWikiRestException((Throwable)e);
            }
            HashSet<String> acceptedMimeTypes = new HashSet<String>();
            if (!types.equals("")) {
                String[] acceptedMimetypesArray;
                for (String type : acceptedMimetypesArray = types.split(",")) {
                    acceptedMimeTypes.add(type);
                }
            }
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String pageSpaceId = (String)fields[0];
                List<String> pageSpaces = Utils.getSpacesFromSpaceId(pageSpaceId);
                String pageName = (String)fields[1];
                String pageId = Utils.getPageId(wikiName, pageSpaces, pageName);
                String pageVersion = (String)fields[2];
                XWikiAttachment xwikiAttachment = (XWikiAttachment)fields[3];
                String mimeType = xwikiAttachment.getMimeType(Utils.getXWikiContext(this.componentManager));
                boolean add = true;
                if (acceptedMimeTypes.size() > 0) {
                    add = false;
                    for (String type : acceptedMimeTypes) {
                        if (!mimeType.toUpperCase().contains(type.toUpperCase())) continue;
                        add = true;
                        break;
                    }
                }
                if (!add) continue;
                org.xwiki.rest.model.jaxb.Attachment attachment = this.objectFactory.createAttachment();
                attachment.setId(String.format("%s@%s", pageId, xwikiAttachment.getFilename()));
                attachment.setName(xwikiAttachment.getFilename());
                attachment.setSize(xwikiAttachment.getFilesize());
                attachment.setMimeType(mimeType);
                attachment.setAuthor(xwikiAttachment.getAuthor());
                if (withPrettyNames.booleanValue()) {
                    attachment.setAuthorName(Utils.getAuthorName(xwikiAttachment.getAuthorReference(), this.componentManager));
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(xwikiAttachment.getDate());
                attachment.setDate(calendar);
                attachment.setPageId(pageId);
                attachment.setPageVersion(pageVersion);
                attachment.setVersion(xwikiAttachment.getVersion());
                URL absoluteUrl = Utils.getXWikiContext(this.componentManager).getURLFactory().createAttachmentURL(xwikiAttachment.getFilename(), pageSpaceId, pageName, "download", null, wikiName, Utils.getXWikiContext(this.componentManager));
                attachment.setXwikiAbsoluteUrl(absoluteUrl.toString());
                attachment.setXwikiRelativeUrl(Utils.getXWikiContext(this.componentManager).getURLFactory().getURL(absoluteUrl, Utils.getXWikiContext(this.componentManager)));
                URI pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageResource.class, wikiName, pageSpaces, pageName);
                Link pageLink = this.objectFactory.createLink();
                pageLink.setHref(pageUri.toString());
                pageLink.setRel("http://www.xwiki.org/rel/page");
                attachment.getLinks().add(pageLink);
                URI attachmentUri = Utils.createURI(this.uriInfo.getBaseUri(), AttachmentResource.class, wikiName, pageSpaces, pageName, xwikiAttachment.getFilename());
                Link attachmentLink = this.objectFactory.createLink();
                attachmentLink.setHref(attachmentUri.toString());
                attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
                attachment.getLinks().add(attachmentLink);
                attachments.getAttachments().add(attachment);
            }
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
        return attachments;
    }

    protected Attachments getAttachmentsForDocument(Document doc, int start, int number, Boolean withPrettyNames) {
        Attachments attachments = this.objectFactory.createAttachments();
        List xwikiAttachments = doc.getAttachmentList();
        RangeIterable ri = new RangeIterable(xwikiAttachments, start, number);
        for (Attachment xwikiAttachment : ri) {
            URL url = Utils.getXWikiContext(this.componentManager).getURLFactory().createAttachmentURL(xwikiAttachment.getFilename(), doc.getSpace(), doc.getName(), "download", null, doc.getWiki(), Utils.getXWikiContext(this.componentManager));
            String attachmentXWikiAbsoluteUrl = url.toString();
            String attachmentXWikiRelativeUrl = Utils.getXWikiContext(this.componentManager).getURLFactory().getURL(url, Utils.getXWikiContext(this.componentManager));
            attachments.getAttachments().add(DomainObjectFactory.createAttachment(this.objectFactory, this.uriInfo.getBaseUri(), xwikiAttachment, attachmentXWikiRelativeUrl, attachmentXWikiAbsoluteUrl, Utils.getXWikiApi(this.componentManager), withPrettyNames));
        }
        return attachments;
    }

    protected AttachmentInfo storeAttachment(Document doc, String attachmentName, byte[] content) throws XWikiException {
        boolean alreadyExisting = false;
        XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getDocumentReference(), Utils.getXWikiContext(this.componentManager));
        XWikiAttachment xwikiAttachment = xwikiDocument.getAttachment(attachmentName);
        if (xwikiAttachment == null) {
            xwikiAttachment = new XWikiAttachment();
            xwikiDocument.getAttachmentList().add(xwikiAttachment);
        } else {
            alreadyExisting = true;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        try {
            xwikiAttachment.setContent((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new XWikiException(3, 3006, String.format("Failed to store the content of attachment [%s] in document [%s].", attachmentName, doc.getPrefixedFullName()), (Throwable)e);
        }
        xwikiAttachment.setAuthor(Utils.getXWikiUser(this.componentManager));
        xwikiAttachment.setFilename(attachmentName);
        xwikiAttachment.setDoc(xwikiDocument);
        Utils.getXWiki(this.componentManager).saveDocument(xwikiDocument, Utils.getXWikiContext(this.componentManager));
        URL url = Utils.getXWikiContext(this.componentManager).getURLFactory().createAttachmentURL(attachmentName, doc.getSpace(), doc.getName(), "download", null, doc.getWiki(), Utils.getXWikiContext(this.componentManager));
        String attachmentXWikiAbsoluteUrl = url.toString();
        String attachmentXWikiRelativeUrl = Utils.getXWikiContext(this.componentManager).getURLFactory().getURL(url, Utils.getXWikiContext(this.componentManager));
        org.xwiki.rest.model.jaxb.Attachment attachment = DomainObjectFactory.createAttachment(this.objectFactory, this.uriInfo.getBaseUri(), new Attachment(doc, xwikiAttachment, Utils.getXWikiContext(this.componentManager)), attachmentXWikiRelativeUrl, attachmentXWikiAbsoluteUrl, Utils.getXWikiApi(this.componentManager), false);
        return new AttachmentInfo(attachment, alreadyExisting);
    }

    protected static class AttachmentInfo {
        protected org.xwiki.rest.model.jaxb.Attachment attachment;
        protected boolean alreadyExisting;

        public AttachmentInfo(org.xwiki.rest.model.jaxb.Attachment attachment, boolean alreadyExisting) {
            this.attachment = attachment;
            this.alreadyExisting = alreadyExisting;
        }

        public org.xwiki.rest.model.jaxb.Attachment getAttachment() {
            return this.attachment;
        }

        public boolean isAlreadyExisting() {
            return this.alreadyExisting;
        }
    }
}

