/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Class;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Classes;
import org.xwiki.rest.resources.classes.ClassesResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.classes.ClassesResourceImpl")
public class ClassesResourceImpl
extends XWikiResource
implements ClassesResource {
    @Inject
    private ModelFactory utils;

    public Classes getClasses(String wikiName, Integer start, Integer number) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            this.getXWikiContext().setWikiId(wikiName);
            List classNames = Utils.getXWikiApi(this.componentManager).getClassList();
            Collections.sort(classNames);
            RangeIterable ri = new RangeIterable(classNames, start, number);
            Classes classes = this.objectFactory.createClasses();
            for (String className : ri) {
                Class xwikiClass = Utils.getXWikiApi(this.componentManager).getClass(className);
                classes.getClazzs().add(this.utils.toRestClass(this.uriInfo.getBaseUri(), xwikiClass));
            }
            Classes classes2 = classes;
            return classes2;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }
}

