/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.Properties;
import org.xwiki.rest.resources.objects.ObjectAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesAtPageVersionResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.objects.ObjectPropertiesAtPageVersionResourceImpl")
public class ObjectPropertiesAtPageVersionResourceImpl
extends XWikiResource
implements ObjectPropertiesAtPageVersionResource {
    public Properties getObjectProperties(String wikiName, String spaceName, String pageName, String version, String className, Integer objectNumber, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, version, true, false);
            Document doc = documentInfo.getDocument();
            XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getDocumentReference(), Utils.getXWikiContext(this.componentManager));
            xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(xwikiDocument, doc.getVersion(), Utils.getXWikiContext(this.componentManager));
            BaseObject baseObject = xwikiDocument.getObject(className, objectNumber.intValue());
            if (baseObject == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            Object object = DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, baseObject, true, Utils.getXWikiApi(this.componentManager), withPrettyNames);
            Properties properties = this.objectFactory.createProperties();
            properties.getProperties().addAll(object.getProperties());
            String objectUri = Utils.createURI(this.uriInfo.getBaseUri(), ObjectAtPageVersionResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), version, object.getClassName(), object.getNumber()).toString();
            Link objectLink = this.objectFactory.createLink();
            objectLink.setHref(objectUri);
            objectLink.setRel("http://www.xwiki.org/rel/object");
            properties.getLinks().add(objectLink);
            return properties;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

