/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.objects.BaseObjectsResource;
import org.xwiki.rest.resources.objects.ObjectResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.objects.ObjectResourceImpl")
public class ObjectResourceImpl
extends BaseObjectsResource
implements ObjectResource {
    @Inject
    private ModelFactory factory;

    public org.xwiki.rest.model.jaxb.Object getObject(String wikiName, String spaceName, String pageName, String className, Integer objectNumber, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            BaseObject baseObject = this.getBaseObject(doc, className, objectNumber);
            if (baseObject == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return this.factory.toRestObject(this.uriInfo.getBaseUri(), doc, baseObject, false, withPrettyNames);
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response updateObject(String wikiName, String spaceName, String pageName, String className, Integer objectNumber, org.xwiki.rest.model.jaxb.Object restObject) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Object xwikiObject = doc.getObject(className, objectNumber.intValue());
            if (xwikiObject == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            this.factory.toObject(xwikiObject, restObject);
            doc.save();
            BaseObject baseObject = this.getBaseObject(doc, className, objectNumber);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((java.lang.Object)this.factory.toRestObject(this.uriInfo.getBaseUri(), doc, baseObject, false, false)).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public void deleteObject(String wikiName, String spaceName, String pageName, String className, Integer objectNumber) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Object object = doc.getObject(className, objectNumber.intValue());
            if (object == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            doc.removeObject(object);
            doc.save();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

