/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.scheduler.JobState;
import com.xpn.xwiki.plugin.scheduler.SchedulerPluginApi;
import com.xpn.xwiki.plugin.scheduler.SchedulerPluginException;
import com.xpn.xwiki.plugin.scheduler.StatusListener;
import com.xpn.xwiki.plugin.scheduler.XWikiServletRequestStub;
import com.xpn.xwiki.plugin.scheduler.XWikiServletResponseStub;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptServiceManager;

public class SchedulerPlugin
extends XWikiDefaultPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerPlugin.class);
    @Deprecated
    public static final String XWIKI_JOB_CLASS = "XWiki.SchedulerJobClass";
    public static final EntityReference XWIKI_JOB_CLASSREFERENCE = new EntityReference("SchedulerJobClass", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private Scheduler scheduler;

    public SchedulerPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(XWikiContext context) {
        try {
            List<String> wikiServers;
            String initialDb;
            String string = initialDb = !context.getDatabase().equals("") ? context.getDatabase() : context.getMainXWiki();
            if (context.getWiki().isVirtualMode()) {
                try {
                    wikiServers = context.getWiki().getVirtualWikisDatabaseNames(context);
                }
                catch (Exception e) {
                    LOGGER.error("error getting list of wiki servers!", (Throwable)e);
                    wikiServers = new ArrayList();
                }
            } else {
                wikiServers = new ArrayList();
            }
            if (!wikiServers.contains(context.getMainXWiki())) {
                wikiServers.add(context.getMainXWiki());
            }
            try {
                for (String wikiName : new ArrayList(wikiServers)) {
                    context.setDatabase(wikiName);
                    try {
                        this.updateSchedulerJobClass(context);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to update scheduler job class for in wiki [{}]", (Object)wikiName, (Object)e);
                        wikiServers.remove(wikiName);
                    }
                }
            }
            finally {
                context.setDatabase(initialDb);
            }
            System.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            System.setProperty("org.quartz.threadPool.makeThreadsDaemons", "true");
            this.setScheduler(this.getDefaultSchedulerInstance());
            this.setStatusListener();
            this.getScheduler().start();
            try {
                for (String wikiName : wikiServers) {
                    context.setDatabase(wikiName);
                    this.restoreExistingJobs(context);
                }
            }
            finally {
                context.setDatabase(initialDb);
            }
        }
        catch (SchedulerException e) {
            LOGGER.error("Failed to start the scheduler", (Throwable)e);
        }
        catch (SchedulerPluginException e) {
            LOGGER.error("Failed to initialize the scheduler", (Throwable)((Object)e));
        }
        super.init(context);
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
    }

    private XWikiContext prepareJobStubContext(BaseObject job, XWikiContext context) throws SchedulerPluginException {
        XWikiURLFactory xurf;
        String cLang;
        boolean jobNeedsUpdate = true;
        String cUser = job.getStringValue("contextUser");
        if (cUser.equals("")) {
            cUser = context.getUser();
            job.setStringValue("contextUser", cUser);
            jobNeedsUpdate = true;
        }
        if ((cLang = job.getStringValue("contextLang")).equals("")) {
            cLang = context.getLanguage();
            job.setStringValue("contextLang", cLang);
            jobNeedsUpdate = true;
        }
        String iDb = context.getDatabase();
        String cDb = job.getStringValue("contextDatabase");
        if (cDb.equals("") || !cDb.equals(iDb)) {
            cDb = context.getDatabase();
            job.setStringValue("contextDatabase", cDb);
            jobNeedsUpdate = true;
        }
        if (jobNeedsUpdate) {
            try {
                context.setDatabase(cDb);
                XWikiDocument jobHolder = context.getWiki().getDocument(job.getName(), context);
                jobHolder.setMinorEdit(true);
                context.getWiki().saveDocument(jobHolder, context);
            }
            catch (XWikiException e) {
                throw new SchedulerPluginException(90011, "Failed to prepare context for job with job name " + job.getStringValue("jobName"), e);
            }
            finally {
                context.setDatabase(iDb);
            }
        }
        XWikiContext scontext = context.clone();
        scontext.setWiki(context.getWiki());
        context.getWiki().getStore().cleanUp(context);
        XWikiServletRequestStub dummy = new XWikiServletRequestStub();
        dummy.setHost(context.getRequest().getHeader("x-forwarded-host"));
        dummy.setScheme(context.getRequest().getScheme());
        dummy.setContextPath(context.getRequest().getContextPath());
        XWikiServletRequest request = new XWikiServletRequest((HttpServletRequest)dummy);
        scontext.setRequest((XWikiRequest)request);
        XWikiServletResponseStub stub = new XWikiServletResponseStub();
        scontext.setResponse((XWikiResponse)stub);
        scontext.setUser(cUser);
        scontext.setLanguage(cLang);
        scontext.setDatabase(cDb);
        scontext.setMainXWiki(context.getMainXWiki());
        if (scontext.getURL() == null) {
            try {
                scontext.setURL(new URL("http://www.mystuburl.com/"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((xurf = context.getURLFactory()) == null) {
            xurf = context.getWiki().getURLFactoryService().createURLFactory(context.getMode(), context);
        }
        scontext.setURLFactory(xurf);
        try {
            XWikiDocument cDoc = context.getWiki().getDocument(job.getName(), context);
            scontext.setDoc(cDoc);
        }
        catch (Exception e) {
            throw new SchedulerPluginException(90011, "Failed to prepare context for job with job name " + job.getStringValue("jobName"), e);
        }
        return scontext;
    }

    private void restoreExistingJobs(XWikiContext context) {
        String hql = ", BaseObject as obj where obj.name=doc.fullName and obj.className='XWiki.SchedulerJobClass'";
        try {
            List jobsDocsNames = context.getWiki().getStore().searchDocumentsNames(hql, context);
            for (String docName : jobsDocsNames) {
                try {
                    XWikiDocument jobDoc = context.getWiki().getDocument(docName, context);
                    BaseObject jobObj = jobDoc.getXObject(XWIKI_JOB_CLASSREFERENCE);
                    String status = jobObj.getStringValue("status");
                    if (status.equals("Normal") || status.equals("Paused")) {
                        this.scheduleJob(jobObj, context);
                    }
                    if (!status.equals("Paused")) continue;
                    this.pauseJob(jobObj, context);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to restore job with in document [{}] and wiki [{}]", (Object)new Object[]{docName, context.getDatabase()}, (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to restore existing scheduler jobs in wiki [{}]", (Object)context.getDatabase(), (Object)e);
        }
    }

    public JobState getJobStatus(BaseObject object, XWikiContext context) throws SchedulerException {
        int state = this.getScheduler().getTriggerState(this.getObjectUniqueId(object, context), "DEFAULT");
        return new JobState(state);
    }

    public boolean scheduleJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        boolean scheduled = true;
        try {
            JobDataMap data = new JobDataMap();
            String xjob = this.getObjectUniqueId(object, context);
            JobDetail job = new JobDetail(xjob, "DEFAULT", Class.forName(object.getStringValue("jobClass")));
            CronTrigger trigger = new CronTrigger(xjob, "DEFAULT", xjob, "DEFAULT", object.getStringValue("cron"));
            XWikiContext stubContext = this.prepareJobStubContext(object, context);
            data.put((Object)"context", (Object)stubContext);
            data.put((Object)"xcontext", (Object)stubContext);
            data.put((Object)"xwiki", (Object)new com.xpn.xwiki.api.XWiki(context.getWiki(), stubContext));
            data.put((Object)"xjob", (Object)object);
            data.put((Object)"services", Utils.getComponent(ScriptServiceManager.class));
            job.setJobDataMap(data);
            this.getScheduler().addJob(job, true);
            JobState status = this.getJobStatus(object, context);
            switch (status.getState()) {
                case 1: {
                    break;
                }
                case 0: {
                    if (this.getTrigger(object, context).compareTo((Object)trigger) != 0) {
                        LOGGER.debug("Reschedule Job: [{}]", (Object)object.getStringValue("jobName"));
                    }
                    this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), (Trigger)trigger);
                    break;
                }
                case -1: {
                    LOGGER.debug("Schedule Job: [{}]", (Object)object.getStringValue("jobName"));
                    this.getScheduler().scheduleJob((Trigger)trigger);
                    LOGGER.info("XWiki Job Status: [{}]", (Object)object.getStringValue("status"));
                    if (object.getStringValue("status").equals("Paused")) {
                        this.getScheduler().pauseJob(xjob, "DEFAULT");
                        this.saveStatus("Paused", object, context);
                        break;
                    }
                    this.saveStatus("Normal", object, context);
                    break;
                }
                default: {
                    LOGGER.debug("Schedule Job: [{}]", (Object)object.getStringValue("jobName"));
                    this.getScheduler().scheduleJob((Trigger)trigger);
                    this.saveStatus("Normal", object, context);
                    break;
                }
            }
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90004, "Error while scheduling job " + object.getStringValue("jobName"), e);
        }
        catch (ParseException e) {
            throw new SchedulerPluginException(90005, "Error while parsing cron expression for job " + object.getStringValue("jobName"), e);
        }
        catch (ClassNotFoundException e) {
            throw new SchedulerPluginException(90006, "Error while loading job class for job : " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90006, "Error while saving job status for job : " + object.getStringValue("jobName"), e);
        }
        return scheduled;
    }

    public void pauseJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().pauseJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("Paused", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90002, "Error occured while trying to pause job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90002, "Error occured while trying to save status of job " + object.getStringValue("jobName"), e);
        }
    }

    public void resumeJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().resumeJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("Normal", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90003, "Error occured while trying to resume job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90003, "Error occured while trying to save status of job " + object.getStringValue("jobName"), e);
        }
    }

    public void triggerJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().triggerJob(this.getObjectUniqueId(object, context), "DEFAULT");
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90012, "Error occured while trying to trigger job " + object.getStringValue("jobName"), e);
        }
    }

    public void unscheduleJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().deleteJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("None", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90006, "Error while unscheduling job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90006, "Error while saving status of job " + object.getStringValue("jobName"), e);
        }
    }

    private Trigger getTrigger(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        Trigger trigger;
        String job = this.getObjectUniqueId(object, context);
        try {
            trigger = this.getScheduler().getTrigger(job, "DEFAULT");
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90006, "Error while getting trigger for job " + job, e);
        }
        if (trigger == null) {
            throw new SchedulerPluginException(90007, "Job does not exists");
        }
        return trigger;
    }

    public Date getPreviousFireTime(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        return this.getTrigger(object, context).getPreviousFireTime();
    }

    public Date getNextFireTime(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        return this.getTrigger(object, context).getNextFireTime();
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new SchedulerPluginApi((SchedulerPlugin)plugin, context);
    }

    public String getName() {
        return "scheduler";
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private synchronized Scheduler getDefaultSchedulerInstance() throws SchedulerPluginException {
        Scheduler scheduler;
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90007, "Error getting default Scheduler instance", e);
        }
        return scheduler;
    }

    private void setStatusListener() throws SchedulerPluginException {
        StatusListener listener = new StatusListener();
        try {
            this.getScheduler().addSchedulerListener((SchedulerListener)listener);
            this.getScheduler().addGlobalJobListener((JobListener)listener);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90001, "Error while initializing the status listener", e);
        }
    }

    private void saveStatus(String status, BaseObject object, XWikiContext context) throws XWikiException {
        XWikiDocument jobHolder = context.getWiki().getDocument(object.getName(), context);
        BaseObject job = jobHolder.getXObject(XWIKI_JOB_CLASSREFERENCE);
        job.setStringValue("status", status);
        jobHolder.setMinorEdit(true);
        context.getWiki().saveDocument(jobHolder, context);
    }

    private String getObjectUniqueId(BaseObject object, XWikiContext context) {
        return context.getDatabase() + ":" + object.getName() + "_" + object.getNumber();
    }

    private boolean setSchedulerClassesDocumentFields(XWikiDocument doc, String title) {
        boolean needsUpdate = false;
        if (StringUtils.isBlank((CharSequence)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((CharSequence)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(doc.getCreator());
        }
        if (StringUtils.isBlank((CharSequence)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((CharSequence)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle(title);
        }
        if (StringUtils.isBlank((CharSequence)doc.getContent()) || !Syntax.XWIKI_2_0.equals((Object)doc.getSyntax())) {
            needsUpdate = true;
            doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
            doc.setSyntax(Syntax.XWIKI_2_0);
        }
        if (!doc.isHidden().booleanValue()) {
            needsUpdate = true;
            doc.setHidden(Boolean.valueOf(true));
        }
        return needsUpdate;
    }

    private void updateSchedulerJobClass(XWikiContext context) throws SchedulerPluginException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        DocumentReference jobClassReference = ((DocumentReferenceResolver)Utils.getComponent((Type)DocumentReferenceResolver.TYPE_REFERENCE, (String)"current")).resolve((Object)XWIKI_JOB_CLASSREFERENCE, new Object[]{EntityType.DOCUMENT});
        try {
            doc = xwiki.getDocument(jobClassReference, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get scheduler job class document", (Throwable)e);
            doc = new XWikiDocument(jobClassReference);
            needsUpdate = true;
        }
        BaseClass bclass = doc.getXClass();
        needsUpdate |= bclass.addTextField("jobName", "Job Name", 60);
        needsUpdate |= bclass.addTextAreaField("jobDescription", "Job Description", 45, 10);
        needsUpdate |= bclass.addTextField("jobClass", "Job Class", 60);
        needsUpdate |= bclass.addTextField("status", "Status", 30);
        needsUpdate |= bclass.addTextField("cron", "Cron Expression", 30);
        needsUpdate |= bclass.addTextAreaField("script", "Job Script", 60, 10);
        TextAreaClass scriptField = (TextAreaClass)bclass.getField("script");
        if (!scriptField.getEditor().equals("puretext")) {
            scriptField.setStringValue("editor", "PureText");
            needsUpdate = true;
        }
        needsUpdate |= bclass.addTextField("contextUser", "Job execution context user", 30);
        needsUpdate |= bclass.addTextField("contextLang", "Job execution context lang", 30);
        needsUpdate |= bclass.addTextField("contextDatabase", "Job execution context database", 30);
        if (needsUpdate |= this.setSchedulerClassesDocumentFields(doc, "XWiki Scheduler Job Class")) {
            try {
                xwiki.saveDocument(doc, context.getMessageTool().get("xe.scheduler.updateJobClassComment"), true, context);
            }
            catch (XWikiException ex) {
                throw new SchedulerPluginException(90000, "Error while saving " + doc + " class document in XWiki", ex);
            }
        }
    }
}

