/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.internal.IndexUpdater;
import com.xpn.xwiki.util.AbstractXWikiRunnable;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;

public class IndexRebuilder
extends AbstractXWikiRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexRebuilder.class);
    private static final int RETRYINTERVAL = 30000;
    private final IndexUpdater indexUpdater;
    private volatile boolean rebuildInProgress = false;
    private Collection<String> wikis = null;
    private String hqlFilter = null;
    private boolean onlyNew = false;
    private XWikiContext xwikiContext;

    protected void declareProperties(ExecutionContext executionContext) {
        this.xwikiContext.declareInExecutionContext(executionContext);
    }

    public IndexRebuilder(IndexUpdater indexUpdater, XWikiContext context) {
        this.xwikiContext = context.clone();
        this.indexUpdater = indexUpdater;
    }

    private XWikiContext getContext() {
        return (XWikiContext)((Execution)Utils.getComponent(Execution.class)).getContext().getProperty("xwikicontext");
    }

    public int startRebuildIndex(XWikiContext context) {
        return this.startIndex(null, "", true, false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int startIndex(Collection<String> wikis, String hqlFilter, boolean clearIndex, boolean onlyNew, XWikiContext context) {
        if (this.rebuildInProgress) {
            LOGGER.warn("Cannot launch rebuild because another rebuild is in progress");
            return -2;
        }
        if (clearIndex) {
            if (wikis == null) {
                this.indexUpdater.cleanIndex();
            } else {
                try (IndexWriter writer = this.indexUpdater.openWriter(false);){
                    for (String wiki : wikis) {
                        writer.deleteDocuments(new Term[]{new Term("wiki", wiki)});
                    }
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to clean wiki index: {}", (Object)ex.getMessage());
                }
            }
        }
        this.wikis = wikis != null ? new ArrayList<String>(wikis) : null;
        this.hqlFilter = hqlFilter;
        this.onlyNew = onlyNew;
        this.rebuildInProgress = true;
        Thread indexRebuilderThread = new Thread((Runnable)((Object)this), "Lucene Index Rebuilder");
        indexRebuilderThread.setDaemon(true);
        indexRebuilderThread.setPriority(3);
        indexRebuilderThread.start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() {
        LOGGER.debug("Starting lucene index rebuild");
        XWikiContext context = null;
        try {
            context = this.getContext();
            context.remove((Object)"hibsession");
            context.remove((Object)"hibtransaction");
            context.remove((Object)"vcontext");
            context.setRequest(null);
            context.setResponse(null);
            this.rebuildIndex(context);
        }
        catch (InterruptedException e) {
            LOGGER.warn("The index rebuilder thread has been interrupted");
        }
        catch (Exception e) {
            LOGGER.error("Error in lucene rebuild thread: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.rebuildInProgress = false;
            if (context != null) {
                context.getWiki().getStore().cleanUp(context);
            }
        }
        LOGGER.debug("Lucene index rebuild done");
    }

    private int rebuildIndex(XWikiContext context) throws InterruptedException {
        int retval = 0;
        Collection<String> wikiServers = this.wikis;
        if (wikiServers == null) {
            wikiServers = this.findWikiServers(context);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("found [{}] virtual wikis:", (Object)wikiServers.size());
                for (String wikiName : wikiServers) {
                    LOGGER.debug(wikiName);
                }
            }
        }
        for (String wikiName : wikiServers) {
            int wikiResult = this.indexWiki(wikiName, context);
            if (wikiResult <= 0) continue;
            retval += wikiResult;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int indexWiki(String wikiName, XWikiContext context) throws InterruptedException {
        LOGGER.info("Reading content of wiki [{}]", (Object)wikiName);
        int retval = 0;
        String database = context.getWikiId();
        try {
            context.setWikiId(wikiName);
            IndexSearcher searcher = this.onlyNew ? this.createSearcher(this.indexUpdater.getDirectory(), context) : null;
            try {
                String hql = "select distinct doc.space, doc.name, doc.version, doc.language from XWikiDocument as doc ";
                if (StringUtils.isNotBlank((CharSequence)this.hqlFilter)) {
                    if (this.hqlFilter.charAt(0) != ',' && !this.hqlFilter.contains("where") && !this.hqlFilter.contains("WHERE")) {
                        hql = hql + "where ";
                    }
                    hql = hql + this.hqlFilter;
                }
                List documents = context.getWiki().search(hql, context);
                retval = this.indexDocuments(wikiName, documents, searcher, context);
            }
            catch (XWikiException e) {
                LOGGER.warn("Error getting document names for wiki [{}] and filter [{}]: {}.", new Object[]{wikiName, this.hqlFilter, e.getMessage()});
                int n = -1;
                context.setWikiId(database);
                return n;
            }
        }
        finally {
            context.setWikiId(database);
        }
        return retval;
    }

    private int indexDocuments(String wikiName, List<Object[]> documents, IndexSearcher searcher, XWikiContext context) throws InterruptedException {
        int retval = 0;
        for (Object[] document : documents) {
            DocumentReference documentReference = new DocumentReference(wikiName, (String)document[0], (String)document[1]);
            String version = (String)document[2];
            String language = (String)document[3];
            if (searcher != null && this.isIndexed(documentReference, version, language, searcher)) continue;
            try {
                retval += this.addTranslationOfDocument(documentReference, language, context);
            }
            catch (XWikiException e) {
                LOGGER.error("Error fetching document [{}] for language [{}]", new Object[]{documentReference, language, e});
                return retval;
            }
        }
        return retval;
    }

    protected int addTranslationOfDocument(DocumentReference documentReference, String language, XWikiContext wikiContext) throws XWikiException, InterruptedException {
        int retval = 0;
        XWikiDocument document = wikiContext.getWiki().getDocument(documentReference, wikiContext);
        XWikiDocument tdocument = document.getTranslatedDocument(language, wikiContext);
        while (this.indexUpdater.getQueueSize() > (long)this.indexUpdater.getMaxQueueSize()) {
            wikiContext.getWiki().getStore().cleanUp(wikiContext);
            Thread.sleep(30000L);
        }
        this.addTranslationOfDocument(tdocument, wikiContext);
        ++retval;
        if (document == tdocument) {
            retval += this.indexUpdater.queueAttachments(document, wikiContext);
        }
        return retval;
    }

    protected void addTranslationOfDocument(XWikiDocument document, XWikiContext wikiContext) {
        this.indexUpdater.queueDocument(document, wikiContext, false);
    }

    private Collection<String> findWikiServers(XWikiContext context) {
        List retval = Collections.emptyList();
        try {
            retval = context.getWiki().getVirtualWikisDatabaseNames(context);
        }
        catch (Exception e) {
            LOGGER.error("Error getting list of wiki servers!", (Throwable)e);
        }
        return retval;
    }

    public boolean isIndexed(DocumentReference documentReference, IndexSearcher searcher) {
        return this.isIndexed(documentReference, null, null, searcher);
    }

    public boolean isIndexed(DocumentReference documentReference, String version, String language, IndexSearcher searcher) {
        boolean exists = false;
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("name", documentReference.getName().toLowerCase())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("space", documentReference.getLastSpaceReference().getName().toLowerCase())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term("wiki", documentReference.getWikiReference().getName().toLowerCase())), BooleanClause.Occur.MUST);
        if (version != null) {
            query.add((Query)new TermQuery(new Term("version", version)), BooleanClause.Occur.MUST);
        }
        if (language != null) {
            query.add((Query)new TermQuery(new Term("lang", StringUtils.isEmpty((CharSequence)language) ? "default" : language)), BooleanClause.Occur.MUST);
        }
        try {
            TopDocs topDocs = searcher.search((Query)query, 1);
            exists = topDocs.totalHits == 1;
        }
        catch (IOException e) {
            LOGGER.error("Faild to search for page [{}] in Lucene index", (Object)documentReference, (Object)e);
        }
        return exists;
    }

    public IndexSearcher createSearcher(Directory directory, XWikiContext context) {
        IndexSearcher searcher = null;
        try {
            searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)directory));
        }
        catch (Exception e) {
            LOGGER.error("Faild to create IndexSearcher for Lucene index [{}]", (Object)directory, (Object)e);
        }
        return searcher;
    }
}

