/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.AbstractAttachmentEvent;
import com.xpn.xwiki.internal.event.AttachmentAddedEvent;
import com.xpn.xwiki.internal.event.AttachmentDeletedEvent;
import com.xpn.xwiki.internal.event.AttachmentUpdatedEvent;
import com.xpn.xwiki.plugin.lucene.LucenePlugin;
import com.xpn.xwiki.plugin.lucene.internal.AbstractIndexData;
import com.xpn.xwiki.plugin.lucene.internal.AttachmentData;
import com.xpn.xwiki.plugin.lucene.internal.DocumentData;
import com.xpn.xwiki.plugin.lucene.internal.WikiData;
import com.xpn.xwiki.plugin.lucene.internal.XWikiDocumentQueue;
import com.xpn.xwiki.util.AbstractXWikiRunnable;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

public class IndexUpdater
extends AbstractXWikiRunnable
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexUpdater.class);
    private static final String NAME = "lucene";
    private static final int EXIT_INTERVAL = 3000;
    private static final List<Event> EVENTS = Arrays.asList(new DocumentUpdatedEvent(), new DocumentCreatedEvent(), new DocumentDeletedEvent(), new AttachmentAddedEvent(), new AttachmentDeletedEvent(), new AttachmentUpdatedEvent());
    public static final List<String> fields = new ArrayList<String>();
    private final LucenePlugin plugin;
    private final int indexingInterval;
    private final Directory directory;
    private final XWikiDocumentQueue queue = new XWikiDocumentQueue();
    private int indexingTimer = 0;
    private final int maxQueueSize;
    private volatile boolean exit = false;
    private Analyzer analyzer;
    private final XWikiContext xwikiContext;

    protected void declareProperties(ExecutionContext executionContext) {
        this.xwikiContext.declareInExecutionContext(executionContext);
    }

    public IndexUpdater(Directory directory, int indexingInterval, int maxQueueSize, LucenePlugin plugin, XWikiContext context) {
        this.xwikiContext = context.clone();
        this.plugin = plugin;
        this.directory = directory;
        this.indexingInterval = indexingInterval;
        this.maxQueueSize = maxQueueSize;
    }

    private XWikiContext getContext() {
        return (XWikiContext)((Execution)Utils.getComponent(Execution.class)).getContext().getProperty("xwikicontext");
    }

    public void doExit() {
        this.exit = true;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    protected void runInternal() {
        this.getContext().setWikiId(this.getContext().getMainXWiki());
        this.runMainLoop();
    }

    private void runMainLoop() {
        while (!this.exit) {
            if (this.indexingTimer == 0) {
                this.indexingTimer = this.indexingInterval;
                this.updateIndex();
            }
            int sleepInterval = Math.min(3000, this.indexingTimer);
            this.indexingTimer -= sleepInterval;
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Error while sleeping", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndex() {
        if (this.queue.isEmpty()) {
            LOGGER.debug("IndexUpdater: queue empty, nothing to do");
        } else {
            IndexWriter writer;
            LOGGER.debug("IndexUpdater: documents in queue, start indexing");
            XWikiContext context = this.getContext();
            context.getWiki().getStore().cleanUp(context);
            try {
                while (true) {
                    try {
                        writer = this.openWriter(false);
                    }
                    catch (CorruptIndexException e) {
                        this.plugin.handleCorruptIndex(context);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to open index", (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                int nb = 0;
                while (!this.queue.isEmpty()) {
                    AbstractIndexData data = this.queue.remove();
                    try {
                        if (data.isDeleted()) {
                            this.removeFromIndex(writer, data, context);
                        } else {
                            this.addToIndex(writer, data, context);
                        }
                        ++nb;
                    }
                    catch (Throwable e) {
                        LOGGER.error("error indexing document [{}]", (Object)data, (Object)e);
                    }
                }
                LOGGER.info("indexed [{}] docs to lucene index", (Object)nb);
            }
            catch (Exception e) {
                LOGGER.error("error indexing documents", (Throwable)e);
            }
            finally {
                try {
                    context.getWiki().getStore().cleanUp(context);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to cleanup hibernate session in lucene index updater.", (Throwable)e);
                }
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close writer.", (Throwable)e);
                }
            }
            this.plugin.openIndexReaders(context);
        }
    }

    protected IndexWriter openWriter(boolean create) throws IOException {
        while (true) {
            try {
                IndexWriterConfig cfg = new IndexWriterConfig(Version.LUCENE_36, this.analyzer);
                if (create) {
                    cfg.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                }
                IndexWriter w = new IndexWriter(this.directory, cfg);
                return w;
            }
            catch (LockObtainFailedException e) {
                try {
                    int s = new Random().nextInt(1000);
                    LOGGER.debug("failed to acquire lock, retrying in {}ms ...", (Object)s);
                    Thread.sleep(s);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private void addToIndex(IndexWriter writer, AbstractIndexData data, XWikiContext context) throws IOException, XWikiException {
        LOGGER.debug("addToIndex: [{}]", (Object)data);
        Document luceneDoc = new Document();
        data.addDataToLuceneDocument(luceneDoc, context);
        for (IndexableField field : luceneDoc.getFields()) {
            if (fields.contains(field.name())) continue;
            fields.add(field.name());
        }
        writer.updateDocument(data.getTerm(), (Iterable)luceneDoc);
    }

    private void removeFromIndex(IndexWriter writer, AbstractIndexData data, XWikiContext context) throws CorruptIndexException, IOException {
        LOGGER.debug("removeFromIndex: [{}]", (Object)data);
        writer.deleteDocuments(new Term[]{data.getTerm()});
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void cleanIndex() {
        LOGGER.info("trying to clear index for rebuilding");
        try {
            this.openWriter(true).close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to clean index", (Throwable)e);
        }
    }

    public void queueDocument(XWikiDocument document, XWikiContext context, boolean deleted) {
        this.queue.add(new DocumentData(document, context, deleted));
    }

    public void queueAttachment(XWikiAttachment attachment, XWikiContext context, boolean deleted) {
        if (attachment != null && context != null) {
            this.queue.add(new AttachmentData(attachment, context, deleted));
        } else {
            LOGGER.error("Invalid parameters given to {} attachment [{}] of document [{}]", new Object[]{deleted ? "deleted" : "added", attachment == null ? null : attachment.getFilename(), attachment == null || attachment.getDoc() == null ? null : attachment.getDoc().getDocumentReference()});
        }
    }

    public void addAttachment(XWikiDocument document, String attachmentName, XWikiContext context, boolean deleted) {
        if (document != null && attachmentName != null && context != null) {
            this.queue.add(new AttachmentData(document, attachmentName, context, deleted));
        } else {
            LOGGER.error("Invalid parameters given to {} attachment [{}] of document [{}]", new Object[]{deleted ? "deleted" : "added", attachmentName, document});
        }
    }

    public void addWiki(String wikiId, boolean deleted) {
        if (wikiId != null) {
            this.queue.add(new WikiData(new WikiReference(wikiId), deleted));
        } else {
            LOGGER.error("Invalid parameters given to {} wiki [{}]", (Object)(deleted ? "deleted" : "added"), (Object)wikiId);
        }
    }

    public int queueAttachments(XWikiDocument document, XWikiContext context) {
        int retval = 0;
        List attachmentList = document.getAttachmentList();
        retval += attachmentList.size();
        for (XWikiAttachment attachment : attachmentList) {
            try {
                this.queueAttachment(attachment, context, false);
            }
            catch (Exception e) {
                LOGGER.error("Failed to retrieve attachment [{}] of document [{}]", new Object[]{attachment.getFilename(), document, e});
            }
        }
        return retval;
    }

    public String getName() {
        return NAME;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiContext context = (XWikiContext)data;
        try {
            if (event instanceof DocumentUpdatedEvent || event instanceof DocumentCreatedEvent) {
                this.queueDocument((XWikiDocument)source, context, false);
            } else if (event instanceof DocumentDeletedEvent) {
                this.queueDocument((XWikiDocument)source, context, true);
            } else if (event instanceof AttachmentUpdatedEvent || event instanceof AttachmentAddedEvent) {
                this.queueAttachment(((XWikiDocument)source).getAttachment(((AbstractAttachmentEvent)event).getName()), context, false);
            } else if (event instanceof AttachmentDeletedEvent) {
                this.addAttachment((XWikiDocument)source, ((AbstractAttachmentEvent)event).getName(), context, true);
            } else if (event instanceof WikiDeletedEvent) {
                this.addWiki((String)source, true);
            }
        }
        catch (Exception e) {
            LOGGER.error("error in notify", (Throwable)e);
        }
    }

    public long getQueueSize() {
        return this.queue.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLuceneDocCount() {
        int n = -1;
        try (IndexWriter w = this.openWriter(false);){
            n = w.numDocs();
        }
        catch (IOException e) {
            LOGGER.error("Failed to get the number of documents in Lucene index writer", (Throwable)e);
        }
        return n;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }
}

