/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.lucene.LucenePluginApi;
import com.xpn.xwiki.plugin.lucene.SearchResults;
import com.xpn.xwiki.plugin.lucene.internal.IndexRebuilder;
import com.xpn.xwiki.plugin.lucene.internal.IndexUpdater;
import com.xpn.xwiki.web.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.Execution;
import org.xwiki.environment.Environment;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;

@Deprecated
public class LucenePlugin
extends XWikiDefaultPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(LucenePlugin.class);
    public static final String DOCTYPE_WIKIPAGE = "wikipage";
    public static final String DOCTYPE_ATTACHMENT = "attachment";
    public static final String PROP_INDEX_DIR = "xwiki.plugins.lucene.indexdir";
    public static final String PROP_ANALYZER = "xwiki.plugins.lucene.analyzer";
    public static final String PROP_INDEXING_INTERVAL = "xwiki.plugins.lucene.indexinterval";
    public static final String PROP_MAX_QUEUE_SIZE = "xwiki.plugins.lucene.maxQueueSize";
    private static final String DEFAULT_ANALYZER = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    private Environment environment = (Environment)Utils.getComponent(Environment.class);
    private Analyzer analyzer;
    private IndexUpdater indexUpdater;
    protected Thread indexUpdaterThread;
    private IndexReader[] indexReaders;
    private String indexDirs;
    private IndexRebuilder indexRebuilder;

    public LucenePlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public String getName() {
        return "lucene";
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new LucenePluginApi((LucenePlugin)plugin, context);
    }

    protected void finalize() throws Throwable {
        LOGGER.error("Lucene plugin will exit!");
        if (this.indexUpdater != null) {
            this.indexUpdater.doExit();
        }
        super.finalize();
    }

    public int rebuildIndex(XWikiContext context) {
        return this.indexRebuilder.startRebuildIndex(context);
    }

    public int startIndex(Collection<String> wikis, String hqlFilter, boolean clearIndex, boolean onlyNew, XWikiContext context) {
        return this.indexRebuilder.startIndex(wikis, hqlFilter, clearIndex, onlyNew, context);
    }

    public SearchResults getSearchResultsFromIndexes(String query, String myIndexDirs, String languages, XWikiContext context) throws Exception {
        IndexReader[] readers = this.createIndexReaders(myIndexDirs, context);
        SearchResults retval = this.search(query, (String)null, null, languages, readers, context);
        return retval;
    }

    public SearchResults getSearchResultsFromIndexes(String query, String[] sortFields, String myIndexDirs, String languages, XWikiContext context) throws Exception {
        IndexReader[] readers = this.createIndexReaders(myIndexDirs, context);
        SearchResults retval = this.search(query, sortFields, null, languages, readers, context);
        return retval;
    }

    public SearchResults getSearchResultsFromIndexes(String query, String sortField, String myIndexDirs, String languages, XWikiContext context) throws Exception {
        IndexReader[] readers = this.createIndexReaders(myIndexDirs, context);
        SearchResults retval = this.search(query, sortField, null, languages, readers, context);
        return retval;
    }

    public SearchResults getSearchResults(String query, String sortField, String virtualWikiNames, String languages, XWikiContext context) throws Exception {
        return this.search(query, sortField, virtualWikiNames, languages, this.indexReaders, context);
    }

    public SearchResults getSearchResults(String query, String[] sortField, String virtualWikiNames, String languages, XWikiContext context) throws Exception {
        return this.search(query, sortField, virtualWikiNames, languages, this.indexReaders, context);
    }

    private SearchResults search(String query, String sortField, String virtualWikiNames, String languages, IndexReader[] indexes, XWikiContext context) throws IOException, ParseException {
        SortField sort = this.getSortField(sortField);
        return this.search(query, sort != null ? new Sort(sort) : null, virtualWikiNames, languages, indexes, context);
    }

    private SearchResults search(String query, String[] sortFields, String virtualWikiNames, String languages, IndexReader[] indexes, XWikiContext context) throws IOException, ParseException {
        Object[] sorts = null;
        if (sortFields != null && sortFields.length > 0) {
            sorts = new SortField[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                sorts[i] = this.getSortField(sortFields[i]);
            }
            int prevLength = -1;
            while (prevLength != sorts.length) {
                prevLength = sorts.length;
                sorts = (SortField[])ArrayUtils.removeElement((Object[])sorts, null);
            }
        }
        return this.search(query, sorts != null ? new Sort((SortField[])sorts) : null, virtualWikiNames, languages, indexes, context);
    }

    private SearchResults search(String query, Sort sort, String virtualWikiNames, String languages, IndexReader[] indexes, XWikiContext context) throws IOException, ParseException {
        IndexSearcher searcher = new IndexSearcher((IndexReader)new MultiReader(indexes, true));
        Query q = this.buildQuery(query, virtualWikiNames, languages);
        Object results = sort != null ? TopFieldCollector.create((Sort)sort, (int)1000, (boolean)true, (boolean)true, (boolean)false, (boolean)false) : TopScoreDocCollector.create((int)1000, (boolean)false);
        searcher.search(q, (Collector)results);
        LOGGER.debug("query [{}] returned {} hits", (Object)q, (Object)results.getTotalHits());
        return new SearchResults((TopDocsCollector<? extends ScoreDoc>)results, searcher, new XWiki(context.getWiki(), context), context);
    }

    private SortField getSortField(String sortField) {
        SortField sort = null;
        if (!StringUtils.isEmpty((CharSequence)sortField)) {
            sort = new SortField(StringUtils.removeStart((String)sortField, (String)"-"), SortField.Type.STRING, sortField.startsWith("-"));
        }
        return sort;
    }

    private Query buildQuery(String query, String virtualWikiNames, String languages) throws ParseException {
        BooleanQuery bQuery = new BooleanQuery();
        Query parsedQuery = null;
        if (query.startsWith("PROP ")) {
            String property = query.substring(0, query.indexOf(":"));
            query = query.substring(query.indexOf(":") + 1, query.length());
            QueryParser qp = new QueryParser(Version.LUCENE_36, property, this.analyzer);
            parsedQuery = qp.parse(query);
            bQuery.add(parsedQuery, BooleanClause.Occur.MUST);
        } else if (query.startsWith("MULTI ")) {
            List<String> fieldList = IndexUpdater.fields;
            String[] fields = fieldList.toArray(new String[fieldList.size()]);
            BooleanClause.Occur[] flags = new BooleanClause.Occur[fields.length];
            for (int i = 0; i < flags.length; ++i) {
                flags[i] = BooleanClause.Occur.SHOULD;
            }
            parsedQuery = MultiFieldQueryParser.parse((Version)Version.LUCENE_36, (String)query, (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)this.analyzer);
            bQuery.add(parsedQuery, BooleanClause.Occur.MUST);
        } else {
            String[] fields = new String[]{"ft", "title", "name", "filename"};
            BooleanClause.Occur[] flags = new BooleanClause.Occur[fields.length];
            for (int i = 0; i < flags.length; ++i) {
                flags[i] = BooleanClause.Occur.SHOULD;
            }
            MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_36, fields, this.analyzer);
            parsedQuery = parser.parse(query);
            parsedQuery.setBoost((float)fields.length);
            bQuery.add(parsedQuery, BooleanClause.Occur.MUST);
        }
        if (virtualWikiNames != null && virtualWikiNames.length() > 0) {
            bQuery.add(this.buildOredTermQuery(virtualWikiNames, "wiki"), BooleanClause.Occur.MUST);
        }
        if (languages != null && languages.length() > 0) {
            bQuery.add(this.buildOredTermQuery(languages, "lang"), BooleanClause.Occur.MUST);
        }
        return bQuery;
    }

    private Query buildOredTermQuery(String values, String fieldname) {
        String[] valueArray = values.split("\\,");
        if (valueArray.length > 1) {
            BooleanQuery orQuery = new BooleanQuery();
            for (int i = 0; i < valueArray.length; ++i) {
                orQuery.add((Query)new TermQuery(new Term(fieldname, valueArray[i].trim())), BooleanClause.Occur.SHOULD);
            }
            return orQuery;
        }
        return new TermQuery(new Term(fieldname, valueArray[0]));
    }

    public synchronized void init(XWikiContext context) {
        FSDirectory directory;
        LOGGER.debug("Lucene plugin: in init");
        this.indexDirs = context.getWiki().Param(PROP_INDEX_DIR);
        if (StringUtils.isEmpty((CharSequence)this.indexDirs)) {
            File workDir = this.getLuceneWorkDirectory();
            this.indexDirs = workDir.getAbsolutePath();
        }
        String indexDir = StringUtils.split((String)this.indexDirs, (String)",")[0];
        File f = new File(indexDir);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            directory = FSDirectory.open((File)f);
        }
        catch (IOException e) {
            LOGGER.error("Failed to open the index directory: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.init((Directory)directory, context);
    }

    public void init(Directory directory, XWikiContext context) {
        int maxQueueSize;
        int indexingInterval;
        try {
            indexingInterval = 1000 * (int)context.getWiki().ParamAsLong(PROP_INDEXING_INTERVAL, 30L);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid indexing interval in configuration.");
            indexingInterval = 30000;
        }
        try {
            maxQueueSize = (int)context.getWiki().ParamAsLong(PROP_MAX_QUEUE_SIZE, 1000L);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid max queue size in configuration.");
            maxQueueSize = 1000;
        }
        IndexUpdater indexUpdater = new IndexUpdater(directory, indexingInterval, maxQueueSize, this, context);
        this.init(indexUpdater, context);
    }

    public void init(IndexUpdater indexUpdater, XWikiContext context) {
        Directory directory = indexUpdater.getDirectory();
        boolean needInitialRebuild = true;
        needInitialRebuild = !DirectoryReader.indexExists((Directory)directory);
        IndexRebuilder indexRebuilder = new IndexRebuilder(indexUpdater, context);
        if (needInitialRebuild) {
            indexRebuilder.startRebuildIndex(context);
            LOGGER.info("Launched initial lucene indexing");
        }
        this.init(indexUpdater, indexRebuilder, context);
    }

    public void init(IndexUpdater indexUpdater, IndexRebuilder indexRebuilder, XWikiContext context) {
        super.init(context);
        try {
            Class<?> clazz = Class.forName(context.getWiki().Param(PROP_ANALYZER, DEFAULT_ANALYZER));
            this.analyzer = (Analyzer)clazz.getConstructor(Version.class).newInstance(Version.LUCENE_36);
        }
        catch (Exception e) {
            LOGGER.error("Error instantiating analyzer: {}", (Object)e.getMessage());
            LOGGER.warn("Using default analyzer class: org.apache.lucene.analysis.standard.StandardAnalyzer");
            try {
                Class<?> clazz = Class.forName(DEFAULT_ANALYZER);
                this.analyzer = (Analyzer)clazz.getConstructor(Version.class).newInstance(Version.LUCENE_36);
            }
            catch (Exception e1) {
                throw new RuntimeException("Instantiation of default analyzer org.apache.lucene.analysis.standard.StandardAnalyzer failed", e1);
            }
        }
        HashMap<String, KeywordAnalyzer> specialAnalyzers = new HashMap<String, KeywordAnalyzer>();
        KeywordAnalyzer preserve = new KeywordAnalyzer();
        specialAnalyzers.put("exactspace", preserve);
        specialAnalyzers.put("wiki", preserve);
        specialAnalyzers.put("type", preserve);
        specialAnalyzers.put("lang", preserve);
        this.analyzer = new PerFieldAnalyzerWrapper(this.analyzer, specialAnalyzers);
        LOGGER.debug("Assigning index updater: {}", (Object)indexUpdater);
        if (this.indexDirs == null) {
            this.indexDirs = context.getWiki().Param(PROP_INDEX_DIR);
            if (StringUtils.isEmpty((CharSequence)this.indexDirs)) {
                File workDir = this.getLuceneWorkDirectory();
                this.indexDirs = workDir.getAbsolutePath();
            }
        }
        this.indexUpdater = indexUpdater;
        this.indexUpdater.setAnalyzer(this.analyzer);
        this.indexUpdaterThread = new Thread((Runnable)((Object)indexUpdater), "Lucene Index Updater");
        this.indexUpdaterThread.start();
        this.indexRebuilder = indexRebuilder;
        this.openIndexReaders(context);
        ObservationManager observationManager = (ObservationManager)Utils.getComponent(ObservationManager.class);
        if (observationManager.getListener(indexUpdater.getName()) == null) {
            observationManager.addListener((EventListener)indexUpdater);
        }
        LOGGER.debug("Lucene plugin initialized.");
    }

    public void flushCache(XWikiContext context) {
        if (context == null) {
            context = (XWikiContext)((Execution)Utils.getComponent(Execution.class)).getContext().getProperty("xwikicontext");
        }
        if (this.indexUpdater != null) {
            ((ObservationManager)Utils.getComponent(ObservationManager.class)).removeListener(this.indexUpdater.getName());
            this.indexUpdater.doExit();
            try {
                this.indexUpdaterThread.join();
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Error while waiting for indexUpdaterThread to die.", (Throwable)ex);
            }
            this.indexUpdater = null;
            this.indexUpdaterThread = null;
        }
        this.indexRebuilder = null;
        this.analyzer = null;
        this.init(context);
    }

    public IndexReader[] createIndexReaders(String indexDirs, XWikiContext context) throws Exception {
        String[] dirs = StringUtils.split((String)indexDirs, (String)",");
        ArrayList<DirectoryReader> readersList = new ArrayList<DirectoryReader>();
        IndexWriterConfig cfg = new IndexWriterConfig(Version.LUCENE_40, this.analyzer);
        block2: for (String dir : dirs) {
            FSDirectory d = FSDirectory.open((File)new File(dir));
            while (true) {
                try {
                    if (!DirectoryReader.indexExists((Directory)d)) {
                        new IndexWriter((Directory)d, cfg).close();
                    }
                    readersList.add(DirectoryReader.open((Directory)d));
                    continue block2;
                }
                catch (CorruptIndexException e) {
                    this.handleCorruptIndex(context);
                    continue;
                }
                break;
            }
        }
        return readersList.toArray(new IndexReader[readersList.size()]);
    }

    public synchronized void openIndexReaders(XWikiContext context) {
        try {
            this.indexReaders = this.createIndexReaders(this.indexDirs, context);
        }
        catch (Exception e) {
            LOGGER.error("Error opening readers for index dirs [{}]", (Object)context.getWiki().Param(PROP_INDEX_DIR), (Object)e);
            throw new RuntimeException("Error opening readers for index dirs " + context.getWiki().Param(PROP_INDEX_DIR), e);
        }
    }

    public String getIndexDirs() {
        return this.indexDirs;
    }

    public long getQueueSize() {
        return this.indexUpdater.getQueueSize();
    }

    public void queueDocument(XWikiDocument doc, XWikiContext context) {
        this.indexUpdater.queueDocument(doc, context, false);
    }

    public void queueAttachment(XWikiDocument doc, XWikiAttachment attach, XWikiContext context) {
        this.indexUpdater.queueAttachment(attach, context, false);
    }

    public void queueAttachment(XWikiDocument doc, XWikiContext context) {
        this.indexUpdater.queueAttachments(doc, context);
    }

    public long getLuceneDocCount() {
        return this.indexUpdater.getLuceneDocCount();
    }

    public void handleCorruptIndex(XWikiContext context) throws IOException {
        this.rebuildIndex(context);
    }

    private File getLuceneWorkDirectory() {
        File dir = new File(this.environment.getPermanentDirectory().getAbsolutePath(), "lucene");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }
}

