/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.search.solr.internal.AbstractSolrInstance;

@Component
@Named(value="embedded")
@InstantiationStrategy(value=ComponentInstantiationStrategy.SINGLETON)
public class EmbeddedSolrInstance
extends AbstractSolrInstance {
    protected static final String CONF_FILE_LOCATION_PATTERN = "/%s/%s";
    protected static final String SOLRCONFIG_XML = "solrconfig.xml";
    protected static final String CONF_DIRECTORY = "conf";
    protected static final String SCHEMA_XML = "schema.xml";
    protected static final String SOLR_XML = "solr.xml";
    protected static final String SOLR_HOME_KEY = "solr.solr.home";
    protected static final String DEFAULT_SOLR_DIRECTORY_NAME = "solr";
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;
    @Inject
    private Environment environment;

    @Override
    public void initialize() throws InitializationException {
        String solrHome = this.determineHomeDirectory();
        try {
            CoreContainer initializedContainer;
            this.validateAndInitializeHomeDirectory(solrHome);
            this.logger.info("Starting embedded Solr server...");
            System.setProperty(SOLR_HOME_KEY, solrHome);
            this.logger.info("Using Solr home directory: {}", (Object)solrHome);
            CoreContainer.Initializer initializer = new CoreContainer.Initializer();
            this.container = initializedContainer = initializer.initialize();
            this.server = new EmbeddedSolrServer(this.container, "");
            this.logger.info("Started embedded Solr server.");
        }
        catch (Exception e) {
            throw new InitializationException(String.format("Failed to initialize the solr embedded server with home directory set to '%s'", solrHome), (Throwable)e);
        }
    }

    private void validateAndInitializeHomeDirectory(String solrHome) throws IllegalArgumentException, IOException {
        String[] fileNames;
        boolean existsButIsUnusable;
        File solrHomeDir = new File(solrHome);
        boolean bl = existsButIsUnusable = solrHomeDir.exists() && (!solrHomeDir.isDirectory() || !solrHomeDir.canWrite());
        if (existsButIsUnusable || !solrHomeDir.exists() && !solrHomeDir.mkdirs()) {
            throw new IllegalArgumentException(String.format("The given path '%s' must be a writable directory", solrHomeDir));
        }
        File confDirectory = new File(solrHomeDir, CONF_DIRECTORY);
        if (!confDirectory.exists()) {
            confDirectory.mkdir();
        }
        this.copyFileIfNotExists(solrHomeDir, SOLR_XML);
        for (String fileName : fileNames = new String[]{SOLRCONFIG_XML, SCHEMA_XML, "protwords.txt", "stopwords.txt", "synonyms.txt", "elevate.xml"}) {
            this.copyFileIfNotExists(confDirectory, fileName);
        }
    }

    private void copyFileIfNotExists(File destinationDirectory, String fileName) throws IOException {
        URL inputUrl;
        File destinationFile = new File(destinationDirectory, fileName);
        if (!destinationFile.exists() && (inputUrl = this.getClass().getResource(String.format(CONF_FILE_LOCATION_PATTERN, CONF_DIRECTORY, fileName))) != null) {
            FileUtils.copyURLToFile((URL)inputUrl, (File)destinationFile);
        }
    }

    private String determineHomeDirectory() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty(SOLR_HOME_KEY))) {
            return System.getProperty(SOLR_HOME_KEY);
        }
        String defaultValue = this.getDefaultHomeDirectory();
        return (String)this.configuration.getProperty("search.solr.home", (Object)defaultValue);
    }

    String getDefaultHomeDirectory() {
        String result = new File(this.environment.getPermanentDirectory(), DEFAULT_SOLR_DIRECTORY_NAME).getPath();
        return result;
    }

    @Override
    public void shutDown() {
        if (this.server != null) {
            ((EmbeddedSolrServer)this.server).shutdown();
        }
    }
}

