/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.search.solr.internal.IndexableReferenceExtractor;
import org.xwiki.search.solr.internal.api.SolrIndex;
import org.xwiki.search.solr.internal.api.SolrIndexException;
import org.xwiki.search.solr.internal.api.SolrInstance;
import org.xwiki.search.solr.internal.metadata.SolrMetadataExtractor;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.SINGLETON)
public class DefaultSolrIndex
implements SolrIndex {
    @Inject
    protected Logger logger;
    @Inject
    protected EntityReferenceSerializer<String> serializer;
    @Inject
    protected Provider<SolrInstance> solrInstanceProvider;
    @Inject
    protected Execution execution;
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected IndexableReferenceExtractor indexableReferenceExtractor;

    @Override
    public void index(EntityReference reference) throws SolrIndexException {
        this.index(Arrays.asList(reference));
    }

    @Override
    public void index(List<EntityReference> references) throws SolrIndexException {
        List<EntityReference> indexableReferences = this.getUniqueIndexableEntityReferences(references);
        List<SolrInputDocument> solrDocuments = this.getSolrDocuments(indexableReferences);
        SolrInstance solrInstance = (SolrInstance)this.solrInstanceProvider.get();
        try {
            solrInstance.add(solrDocuments);
            solrInstance.commit();
        }
        catch (Exception e) {
            String message = "Failed to push index changes to the Solr server. Rolling back.";
            this.logger.error(message, (Throwable)e);
            try {
                solrInstance.rollback();
            }
            catch (Exception ex) {
                this.logger.error("Failed to rollback index changes.", (Throwable)ex);
            }
            throw new SolrIndexException(message, e);
        }
    }

    protected List<EntityReference> getUniqueIndexableEntityReferences(List<EntityReference> startReferences) throws SolrIndexException {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        for (EntityReference reference : startReferences) {
            if (result.contains(reference)) continue;
            List<EntityReference> containedReferences = this.indexableReferenceExtractor.getReferences(reference);
            for (EntityReference containedReference : containedReferences) {
                if (result.contains(containedReference)) continue;
                result.add(containedReference);
            }
        }
        return result;
    }

    private List<SolrInputDocument> getSolrDocuments(List<EntityReference> references) throws SolrIndexException, IllegalArgumentException {
        ArrayList<SolrInputDocument> solrDocuments = new ArrayList<SolrInputDocument>();
        for (EntityReference reference : references) {
            SolrInputDocument entitySolrDocument;
            SolrMetadataExtractor metadataExtractor = this.getMetadataExtractor(reference.getType());
            if (metadataExtractor == null || (entitySolrDocument = metadataExtractor.getSolrDocument(reference)) == null) continue;
            solrDocuments.add(entitySolrDocument);
        }
        return solrDocuments;
    }

    protected SolrMetadataExtractor getMetadataExtractor(EntityType entityType) {
        SolrMetadataExtractor result = null;
        try {
            result = (SolrMetadataExtractor)this.componentManager.getInstance(SolrMetadataExtractor.class, entityType.name().toLowerCase());
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void delete(EntityReference reference) throws SolrIndexException {
        this.delete(Arrays.asList(reference));
    }

    @Override
    public void delete(List<EntityReference> references) throws SolrIndexException {
        List<EntityReference> indexableReferences = this.getUniqueIndexableEntityReferences(references);
        List<String> ids = this.getIds(indexableReferences);
        SolrInstance solrInstance = (SolrInstance)this.solrInstanceProvider.get();
        try {
            solrInstance.delete(ids);
            solrInstance.commit();
        }
        catch (Exception e) {
            String message = "Failed to push index deletions to the Solr server. Rolling back.";
            this.logger.error(message, (Throwable)e);
            try {
                solrInstance.rollback();
            }
            catch (Exception re) {
                this.logger.error("Failed to rollback index deletions.", (Throwable)re);
            }
            throw new SolrIndexException(message, e);
        }
    }

    protected XWikiContext getXWikiContext() {
        ExecutionContext executionContext = this.execution.getContext();
        XWikiContext context = (XWikiContext)executionContext.getProperty("xwikicontext");
        return context;
    }

    protected List<String> getIds(List<EntityReference> references) throws SolrIndexException {
        ArrayList<String> result = new ArrayList<String>();
        for (EntityReference reference : references) {
            SolrMetadataExtractor metadataExtractor = this.getMetadataExtractor(reference.getType());
            if (metadataExtractor == null) continue;
            String id = metadataExtractor.getId(reference);
            result.add(id);
        }
        return result;
    }
}

