/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.search.solr.internal.api.SolrIndex;
import org.xwiki.search.solr.internal.api.SolrIndexException;

@Component
@Named(value="solr")
public class SolrIndexScriptService
implements ScriptService {
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    @Inject
    protected Execution execution;
    @Inject
    protected Logger logger;
    @Inject
    protected SolrIndex solrIndex;

    public void index(EntityReference reference) {
        this.clearException();
        try {
            this.solrIndex.index(reference);
        }
        catch (SolrIndexException e) {
            this.error(e);
        }
    }

    public void index(List<EntityReference> references) {
        this.clearException();
        try {
            this.solrIndex.index(references);
        }
        catch (SolrIndexException e) {
            this.error(e);
        }
    }

    public void delete(EntityReference reference) {
        this.clearException();
        try {
            this.solrIndex.delete(reference);
        }
        catch (SolrIndexException e) {
            this.error(e);
        }
    }

    public void delete(List<EntityReference> references) {
        this.clearException();
        try {
            this.solrIndex.delete(references);
        }
        catch (SolrIndexException e) {
            this.error(e);
        }
    }

    private void error(String errorMessage, Exception e) {
        String errorMessageToLog = errorMessage;
        if (errorMessageToLog == null) {
            errorMessageToLog = e.getMessage();
        }
        this.logger.error(errorMessageToLog, (Throwable)e);
        this.getXWikiContext().put((Object)CONTEXT_LASTEXCEPTION, (Object)e);
    }

    private void error(Exception e) {
        this.error(null, e);
    }

    private void clearException() {
        this.getXWikiContext().remove((Object)CONTEXT_LASTEXCEPTION);
    }

    protected XWikiContext getXWikiContext() {
        ExecutionContext executionContext = this.execution.getContext();
        XWikiContext context = (XWikiContext)executionContext.getProperty("xwikicontext");
        return context;
    }
}

