/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.search.solr.internal.AbstractSolrInstance;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Named(value="embedded")
@Singleton
public class EmbeddedSolrInstance
extends AbstractSolrInstance {
    public static final String TYPE = "embedded";
    public static final String SOLR_HOME_SYSTEM_PROPERTY = "solr.solr.home";
    public static final String DEFAULT_SOLR_DIRECTORY_NAME = "solr";
    @Inject
    private SolrConfiguration solrConfiguration;
    @Inject
    private Environment environment;

    @Override
    public void initialize() throws InitializationException {
        String solrHome = this.determineHomeDirectory();
        try {
            this.validateAndInitializeHomeDirectory(solrHome);
            this.logger.info("Starting embedded Solr server...");
            System.setProperty(SOLR_HOME_SYSTEM_PROPERTY, solrHome);
            this.logger.info("Using Solr home directory: {}", (Object)solrHome);
            CoreContainer.Initializer initializer = new CoreContainer.Initializer();
            CoreContainer initializedContainer = initializer.initialize();
            if (initializedContainer.getCores().size() == 0) {
                throw new SolrServerException("Failed to initialize the Solr core. Please check the configuration and log messages");
            }
            this.container = initializedContainer;
            this.server = new EmbeddedSolrServer(this.container, "");
            this.logger.info("Started embedded Solr server.");
        }
        catch (Exception e) {
            throw new InitializationException(String.format("Failed to initialize the solr embedded server with home directory set to '%s'", solrHome), (Throwable)e);
        }
    }

    private void validateAndInitializeHomeDirectory(String solrHome) throws IllegalArgumentException, IOException {
        File solrHomeDirectory = new File(solrHome);
        if (solrHomeDirectory.exists()) {
            if (!(solrHomeDirectory.isDirectory() && solrHomeDirectory.canWrite() && solrHomeDirectory.canRead())) {
                throw new IllegalArgumentException(String.format("The given path '%s' must be a readable and writable directory", solrHomeDirectory));
            }
        } else {
            if (!solrHomeDirectory.mkdirs()) {
                throw new IllegalArgumentException(String.format("The given path '%s' could not be created due to insufficient filesystem permissions", solrHomeDirectory));
            }
            Map<String, URL> homeDirectoryConfiguration = this.solrConfiguration.getHomeDirectoryConfiguration();
            for (Map.Entry<String, URL> file : homeDirectoryConfiguration.entrySet()) {
                File destinationFile = new File(solrHomeDirectory, file.getKey());
                FileUtils.copyURLToFile((URL)file.getValue(), (File)destinationFile);
            }
        }
    }

    private String determineHomeDirectory() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty(SOLR_HOME_SYSTEM_PROPERTY))) {
            return System.getProperty(SOLR_HOME_SYSTEM_PROPERTY);
        }
        String defaultValue = this.getDefaultHomeDirectory();
        return this.solrConfiguration.getInstanceConfiguration(TYPE, "home", defaultValue);
    }

    String getDefaultHomeDirectory() {
        String result = new File(this.environment.getPermanentDirectory(), DEFAULT_SOLR_DIRECTORY_NAME).getPath();
        return result;
    }
}

