/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.search.solr.internal.AbstractSolrInstance;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Named(value="remote")
@Singleton
public class RemoteSolrInstance
extends AbstractSolrInstance {
    public static final String TYPE = "remote";
    public static final String DEFAULT_REMOTE_URL = "http://localhost:8983/solr/";
    public static final String CONFIGURATION_ZIP_FILE_NAME = "conf.zip";
    @Inject
    private Execution execution;
    @Inject
    private SolrConfiguration configuration;
    @Inject
    private Logger logger;

    @Override
    public void initialize() throws InitializationException {
        String remoteURL = this.configuration.getInstanceConfiguration(TYPE, "url", DEFAULT_REMOTE_URL);
        try {
            this.generateAndAttachConfigurationZipIfNotExist();
        }
        catch (Exception e) {
            this.logger.error("Failed to generate the remote server's configuration.", (Throwable)e);
        }
        this.server = new HttpSolrServer(remoteURL);
    }

    public void generateAndAttachConfigurationZipIfNotExist() throws Exception {
        DocumentReference configDocumentReference;
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        XWikiDocument configurationDocument = xwiki.getDocument(configDocumentReference = new DocumentReference(this.getXWikiContext().getMainXWiki(), "XWiki", "SolrSearchAdmin"), context);
        XWikiAttachment configurationZipAttachment = configurationDocument.getAttachment(CONFIGURATION_ZIP_FILE_NAME);
        if (configurationZipAttachment == null) {
            Map<String, URL> homeDirectoryFiles = this.configuration.getHomeDirectoryConfiguration();
            InputStream zipFileInputStream = RemoteSolrInstance.createZip(homeDirectoryFiles);
            configurationDocument.addAttachment(CONFIGURATION_ZIP_FILE_NAME, zipFileInputStream, context);
        }
    }

    private static InputStream createZip(Map<String, URL> files) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipfile = new ZipOutputStream(baos);
        for (Map.Entry<String, URL> file : files.entrySet()) {
            zipfile.putNextEntry(new ZipEntry(file.getKey()));
            URL fileURL = file.getValue();
            byte[] fileData = IOUtils.toByteArray((InputStream)fileURL.openStream());
            zipfile.write(fileData);
        }
        zipfile.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

