/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.user.api.XWikiRightService;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.search.solr.internal.api.SolrConfiguration;
import org.xwiki.search.solr.internal.api.SolrIndex;

@Component
@Named(value="solr")
public class SolrIndexScriptService
implements ScriptService {
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    @Inject
    protected SolrConfiguration configuration;
    @Inject
    protected Execution execution;
    @Inject
    protected Logger logger;
    @Inject
    protected SolrIndex solrIndex;

    public void index(EntityReference reference) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(reference);
            this.solrIndex.index(reference);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void index(List<EntityReference> references) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(references);
            this.solrIndex.index(references);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void delete(EntityReference reference) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(reference);
            this.solrIndex.delete(reference);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void delete(List<EntityReference> references) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(references);
            this.solrIndex.delete(references);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public List<String> getOptimizableLanguages() {
        this.clearException();
        return this.configuration.getOptimizableLanguages();
    }

    public List<String> getOptimizedLanguages() {
        this.clearException();
        return this.configuration.getOptimizedLanguages();
    }

    private void error(String errorMessage, Exception e) {
        String errorMessageToLog = errorMessage;
        if (errorMessageToLog == null) {
            errorMessageToLog = e.getMessage();
        }
        this.logger.error(errorMessageToLog, (Throwable)e);
        this.getXWikiContext().put((Object)CONTEXT_LASTEXCEPTION, (Object)e);
    }

    private void error(Exception e) {
        this.error(null, e);
    }

    private void clearException() {
        this.getXWikiContext().remove((Object)CONTEXT_LASTEXCEPTION);
    }

    protected XWikiContext getXWikiContext() {
        ExecutionContext executionContext = this.execution.getContext();
        XWikiContext context = (XWikiContext)executionContext.getProperty("xwikicontext");
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAccessToWikiIndex(EntityReference reference) throws IllegalAccessException {
        WikiReference wikiReference = (WikiReference)reference.extractReference(EntityType.WIKI);
        String wikiName = wikiReference.getName();
        XWikiContext context = this.getXWikiContext();
        XWikiRightService rightService = context.getWiki().getRightService();
        String currentDatabase = context.getDatabase();
        try {
            context.setDatabase(wikiName);
            if (!rightService.hasWikiAdminRights(context) || !rightService.hasProgrammingRights(context)) {
                throw new IllegalAccessException(String.format("The user '%s' is not allowed to alter the index for the entity '%s'", this.getXWikiContext().getUserReference(), reference));
            }
        }
        finally {
            context.setDatabase(currentDatabase);
        }
    }

    private void checkAccessToWikiIndex(List<EntityReference> references) throws IllegalAccessException {
        HashMap<EntityReference, EntityReference> representatives = new HashMap<EntityReference, EntityReference>();
        for (EntityReference reference : references) {
            EntityReference wikiReference = reference.extractReference(EntityType.WIKI);
            if (representatives.containsKey(wikiReference)) continue;
            representatives.put(wikiReference, reference);
        }
        for (EntityReference reference : representatives.values()) {
            this.checkAccessToWikiIndex(reference);
        }
    }
}

