/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.search.solr.internal.api.SolrIndexException;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;

@Component
@Named(value="document")
public class DocumentSolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Inject
    @Named(value="plain/1.0")
    protected BlockRenderer renderer;

    @Override
    public SolrInputDocument getSolrDocument(EntityReference entityReference) throws SolrIndexException, IllegalArgumentException {
        DocumentReference documentReference = new DocumentReference(entityReference);
        XWikiContext context = this.getXWikiContext();
        try {
            SolrInputDocument solrDocument = new SolrInputDocument();
            XWikiDocument translatedDocument = this.getTranslatedDocument(documentReference);
            String language = this.getLanguage(documentReference);
            solrDocument.addField("id", (Object)this.getId((EntityReference)documentReference));
            this.addDocumentFields(documentReference, solrDocument);
            solrDocument.addField("type", (Object)documentReference.getType().name());
            solrDocument.addField("fullname", this.localSerializer.serialize((EntityReference)documentReference, new Object[0]));
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.renderer.render((Block)translatedDocument.getXDOM(), (WikiPrinter)printer);
            String plainTitle = translatedDocument.getRenderedTitle(Syntax.PLAIN_1_0, context);
            solrDocument.addField(String.format("%s_%s", "title", language), (Object)plainTitle);
            solrDocument.addField(String.format("%s_%s", "doccontent", language), (Object)printer.toString());
            solrDocument.addField("version", (Object)translatedDocument.getVersion());
            String authorString = (String)this.serializer.serialize((EntityReference)translatedDocument.getAuthorReference(), new Object[0]);
            String authorDisplayString = context.getWiki().getUserName(authorString, null, false, context);
            String creatorString = (String)this.serializer.serialize((EntityReference)translatedDocument.getCreatorReference(), new Object[0]);
            String creatorDisplayString = context.getWiki().getUserName(creatorString, null, false, context);
            solrDocument.addField("author", (Object)authorString);
            solrDocument.addField("author_display", (Object)authorDisplayString);
            solrDocument.addField("creator", (Object)creatorString);
            solrDocument.addField("creator_display", (Object)creatorDisplayString);
            solrDocument.addField("creationdate", (Object)translatedDocument.getCreationDate());
            solrDocument.addField("date", (Object)translatedDocument.getContentUpdateDate());
            solrDocument.setField("hidden", (Object)translatedDocument.isHidden());
            this.addExtras(documentReference, solrDocument, language);
            return solrDocument;
        }
        catch (Exception e) {
            throw new SolrIndexException(String.format("Failed to get input document for '%s'", this.serializer.serialize((EntityReference)documentReference, new Object[0])), e);
        }
    }

    protected void addExtras(DocumentReference documentReference, SolrInputDocument solrDocument, String language) throws XWikiException {
        XWikiDocument originalDocument = this.getDocument(documentReference);
        this.addComments(solrDocument, originalDocument, language);
        this.addObjects(solrDocument, language, originalDocument);
    }

    protected void addObjects(SolrInputDocument solrDocument, String language, XWikiDocument originalDocument) {
        for (Map.Entry objects : originalDocument.getXObjects().entrySet()) {
            for (BaseObject object : (List)objects.getValue()) {
                this.addObjectContent(solrDocument, object, language);
            }
        }
    }

    protected void addComments(SolrInputDocument solrDocument, XWikiDocument originalDocument, String language) {
        Vector comments = originalDocument.getComments();
        if (comments == null) {
            return;
        }
        for (BaseObject comment : comments) {
            if (comment == null) continue;
            String commentString = comment.getStringValue("comment");
            String author = comment.getStringValue("author");
            Date date = comment.getDateValue("date");
            solrDocument.addField(String.format("%s_%s", "comment", language), (Object)String.format("%s by %s on %s", commentString, author, date));
        }
    }

    @Override
    public String getId(EntityReference reference) throws SolrIndexException, IllegalArgumentException {
        DocumentReference documentReference = new DocumentReference(reference);
        String result = super.getId(reference);
        result = result + "_" + this.getLanguage(documentReference);
        return result;
    }
}

