/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.List;
import javax.inject.Named;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.search.solr.internal.api.SolrIndexException;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;

@Component
@Named(value="object")
public class ObjectSolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Override
    public SolrInputDocument getSolrDocument(EntityReference entityReference) throws SolrIndexException, IllegalArgumentException {
        BaseObjectReference objectReference = new BaseObjectReference(entityReference);
        try {
            SolrInputDocument solrDocument = new SolrInputDocument();
            DocumentReference classReference = objectReference.getXClassReference();
            DocumentReference documentReference = new DocumentReference(objectReference.getParent());
            XWikiDocument document = this.getDocument(documentReference);
            BaseObject object = document.getXObject((ObjectReference)objectReference);
            solrDocument.addField("id", (Object)this.getId(object.getReference()));
            this.addDocumentFields(documentReference, solrDocument);
            solrDocument.addField("type", (Object)objectReference.getType().name());
            solrDocument.addField("class", this.localSerializer.serialize((EntityReference)classReference, new Object[0]));
            this.addLanguageAndContentFields(documentReference, solrDocument, object);
            return solrDocument;
        }
        catch (Exception e) {
            throw new SolrIndexException(String.format("Failed to get Solr document for '%s'", this.serializer.serialize((EntityReference)objectReference, new Object[0])), e);
        }
    }

    protected void addLanguageAndContentFields(DocumentReference documentReference, SolrInputDocument solrDocument, BaseObject object) throws Exception {
        String originalDocumentLanguage;
        XWikiDocument originalDocument = this.getDocument(documentReference);
        List documentLanguages = originalDocument.getTranslationList(this.getXWikiContext());
        if (!documentLanguages.contains(originalDocumentLanguage = this.getLanguage(documentReference))) {
            documentLanguages.add(originalDocumentLanguage);
        }
        for (String documentLanguage : documentLanguages) {
            if (!documentLanguage.equals(originalDocumentLanguage)) {
                solrDocument.addField("lang", (Object)documentLanguage);
            }
            this.addObjectContent(solrDocument, object, documentLanguage);
        }
        this.addObjectContent(solrDocument, object, "ml");
    }
}

