/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.reference;

import com.google.common.collect.Iterables;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.reference.AbstractSolrReferenceResolver;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@Named(value="document")
@Singleton
public class DocumentSolrReferenceResolver
extends AbstractSolrReferenceResolver {
    @Inject
    @Named(value="object")
    protected Provider<SolrReferenceResolver> objectResolverProvider;
    @Inject
    @Named(value="space")
    protected Provider<SolrReferenceResolver> spaceResolverProvider;
    @Inject
    @Named(value="attachment")
    protected Provider<SolrReferenceResolver> attachmentResolverProvider;

    public List<EntityReference> getReferences(EntityReference reference) throws SolrIndexerException {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference documentReference = new DocumentReference(reference);
        if (xcontext.getWiki().exists(documentReference, xcontext)) {
            result.add((EntityReference)documentReference);
            if (documentReference.getLocale() == null || documentReference.getLocale().equals(Locale.ROOT)) {
                List translatedLocales;
                XWikiDocument document;
                try {
                    document = this.getDocument(documentReference);
                }
                catch (Exception e) {
                    throw new SolrIndexerException(String.format("Failed to get document [%s]", documentReference), e);
                }
                try {
                    translatedLocales = document.getTranslationLocales(xcontext);
                }
                catch (XWikiException e) {
                    throw new SolrIndexerException(String.format("Failed to get document [%s] translations", documentReference), (Exception)((Object)e));
                }
                for (Locale translatedLocale : translatedLocales) {
                    DocumentReference translatedDocumentReference = new DocumentReference((EntityReference)documentReference, translatedLocale);
                    result.add((EntityReference)translatedDocumentReference);
                }
                this.addAttachmentsReferences(document, result);
                this.addObjectsReferences(document, result);
            }
        }
        return result;
    }

    private void addAttachmentsReferences(XWikiDocument document, List<EntityReference> result) {
        List attachments = document.getAttachmentList();
        for (XWikiAttachment attachment : attachments) {
            AttachmentReference attachmentReference = attachment.getReference();
            try {
                Iterables.addAll(result, ((SolrReferenceResolver)this.attachmentResolverProvider.get()).getReferences((EntityReference)attachmentReference));
            }
            catch (Exception e) {
                this.logger.error("Failed to resolve references for attachment [" + attachmentReference + "]", (Throwable)e);
            }
        }
    }

    private void addObjectsReferences(XWikiDocument document, List<EntityReference> result) {
        for (Map.Entry entry : document.getXObjects().entrySet()) {
            List objects = (List)entry.getValue();
            for (BaseObject object : objects) {
                if (object == null) continue;
                BaseObjectReference objectReference = (BaseObjectReference)object.getReference();
                try {
                    Iterables.addAll(result, ((SolrReferenceResolver)this.objectResolverProvider.get()).getReferences((EntityReference)objectReference));
                }
                catch (Exception e) {
                    this.logger.error("Failed to resolve references for object [" + objectReference + "]", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getId(EntityReference reference) throws SolrIndexerException {
        DocumentReference documentReference = new DocumentReference(reference);
        String result = super.getId(reference);
        result = result + "_" + this.getLocale(documentReference);
        return result;
    }

    protected Locale getLocale(DocumentReference documentReference) throws SolrIndexerException {
        Locale locale = null;
        try {
            if (documentReference.getLocale() != null && !documentReference.getLocale().equals(Locale.ROOT)) {
                locale = documentReference.getLocale();
            } else {
                XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
                locale = xcontext.getWiki().getDocument(documentReference, xcontext).getRealLocale();
            }
        }
        catch (Exception e) {
            throw new SolrIndexerException(String.format("Exception while fetching the locale of the document '%s'", documentReference), e);
        }
        return locale;
    }

    @Override
    public String getQuery(EntityReference reference) throws SolrIndexerException {
        StringBuilder builder = new StringBuilder();
        EntityReference spaceReference = reference.extractReference(EntityType.SPACE);
        builder.append(((SolrReferenceResolver)this.spaceResolverProvider.get()).getQuery(spaceReference));
        builder.append(" AND ");
        builder.append("name_exact");
        builder.append(':');
        builder.append(ClientUtils.escapeQueryChars((String)reference.getName()));
        return builder.toString();
    }
}

