/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="solr")
@Singleton
public class SolrFieldStringEntityReferenceSerializer
implements EntityReferenceSerializer<String> {
    static final String SEPARATOR = String.valueOf('.');
    static final String ESCAPED_SEPARATOR = SEPARATOR + SEPARATOR;

    public String serialize(EntityReference reference, Object ... parameters) {
        if (reference == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        for (EntityReference parent : reference.getReversedReferenceChain()) {
            output.append(SEPARATOR).append(parent.getName().replace(SEPARATOR, ".."));
        }
        return output.substring(1);
    }
}

