/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import java.util.Collection;
import java.util.Set;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightSet;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.internal.AbstractAuthorizationSettler;
import org.xwiki.security.authorization.internal.XWikiSecurityAccess;

@Component
@Singleton
public class DefaultAuthorizationSettler
extends AbstractAuthorizationSettler {
    @Override
    protected XWikiSecurityAccess settle(UserSecurityReference user, Collection<GroupSecurityReference> groups, SecurityRuleEntry entry, AbstractAuthorizationSettler.Policies policies) {
        Set<Right> enabledRights = Right.getEnabledRights(entry.getReference().getSecurityType());
        RightSet fromUser = new RightSet();
        RightSet allowed = new RightSet();
        XWikiSecurityAccess access = new XWikiSecurityAccess();
        for (Right right : enabledRights) {
            for (SecurityRule rule : entry.getRules()) {
                if (!rule.match(right)) continue;
                if (rule.getState() == RuleState.ALLOW) {
                    allowed.add(right);
                }
                this.resolveLevel(right, user, groups, rule, access, policies, fromUser);
                if (access.get(right) != RuleState.ALLOW) continue;
                this.implyRights(right, access, enabledRights, policies, fromUser);
            }
        }
        for (Right right : allowed) {
            if (access.get(right) != RuleState.UNDETERMINED) continue;
            access.deny(right);
        }
        return access;
    }

    private void implyRights(Right right, XWikiSecurityAccess access, Set<Right> enabledRights, AbstractAuthorizationSettler.Policies policies, Set<Right> fromUser) {
        Set<Right> impliedRights = right.getImpliedRights();
        if (impliedRights != null) {
            for (Right enabledRight : enabledRights) {
                if (!impliedRights.contains(enabledRight)) continue;
                policies.set(enabledRight, right);
                if (fromUser.contains(enabledRight) == fromUser.contains(right)) {
                    this.resolveConflict(RuleState.ALLOW, enabledRight, access, policies);
                    continue;
                }
                if (!fromUser.contains(right)) continue;
                access.set(enabledRight, RuleState.ALLOW);
                fromUser.add(enabledRight);
            }
        }
    }

    private void resolveLevel(Right right, UserSecurityReference user, Collection<GroupSecurityReference> groups, SecurityRule rule, XWikiSecurityAccess access, AbstractAuthorizationSettler.Policies policies, Set<Right> fromUser) {
        RuleState state = rule.getState();
        if (state == RuleState.UNDETERMINED) {
            return;
        }
        if (rule.match(user)) {
            if (!fromUser.contains(right)) {
                access.set(right, state);
                fromUser.add(right);
            } else {
                this.resolveConflict(state, right, access, policies);
            }
        } else if (!fromUser.contains(right)) {
            for (GroupSecurityReference group : groups) {
                if (!rule.match(group)) continue;
                this.resolveConflict(state, right, access, policies);
                break;
            }
        }
    }

    private void resolveConflict(RuleState state, Right right, XWikiSecurityAccess access, AbstractAuthorizationSettler.Policies policies) {
        if (access.get(right) == RuleState.UNDETERMINED) {
            access.set(right, state);
            return;
        }
        if (access.get(right) != state) {
            access.set(right, policies.getTieResolutionPolicy(right));
        }
    }
}

