/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization;

import java.util.Formatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightDescription;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityAccess;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.UnableToRegisterRightException;
import org.xwiki.security.authorization.cache.SecurityCache;
import org.xwiki.security.authorization.cache.SecurityCacheLoader;
import org.xwiki.security.authorization.internal.XWikiSecurityAccess;
import org.xwiki.security.internal.XWikiBridge;

@Component
@Singleton
public class DefaultAuthorizationManager
implements AuthorizationManager {
    @Inject
    private Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityCacheLoader securityCacheLoader;
    @Inject
    private SecurityReferenceFactory securityReferenceFactory;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private XWikiBridge xwikiBridge;

    private boolean isSuperAdmin(DocumentReference user) {
        return StringUtils.equalsIgnoreCase((CharSequence)user.getName(), (CharSequence)"superadmin");
    }

    @Override
    public void checkAccess(Right right, DocumentReference userReference, EntityReference entityReference) throws AccessDeniedException {
        try {
            if (!this.hasSecurityAccess(right, userReference, entityReference)) {
                throw new AccessDeniedException(userReference, entityReference);
            }
        }
        catch (Exception e) {
            throw new AccessDeniedException(userReference, entityReference, (Throwable)e);
        }
    }

    @Override
    public boolean hasAccess(Right right, DocumentReference userReference, EntityReference entityReference) {
        try {
            return this.hasSecurityAccess(right, userReference, entityReference);
        }
        catch (Exception e) {
            this.logger.error("Failed to load rights for user {}.", (Object)userReference, (Object)e);
            return false;
        }
    }

    private boolean hasSecurityAccess(Right right, DocumentReference userReference, EntityReference entityReference) throws AuthorizationException {
        if (userReference == null) {
            this.logDeny(userReference, entityReference, right, "missing user");
            return false;
        }
        if (this.isSuperAdmin(userReference)) {
            return true;
        }
        if (right == null || right == Right.ILLEGAL) {
            this.logDeny(userReference, entityReference, right, "no such right");
            return false;
        }
        if (!right.isReadOnly() && this.xwikiBridge.isWikiReadOnly()) {
            return false;
        }
        SecurityAccess securityAccess = this.getAccess(this.securityReferenceFactory.newUserReference(userReference), this.securityReferenceFactory.newEntityReference(entityReference));
        RuleState access = securityAccess.get(right);
        this.logAccess(access, userReference, entityReference, right, "access checked");
        return access == RuleState.ALLOW;
    }

    @Override
    public Right register(RightDescription rightDescription) throws UnableToRegisterRightException {
        try {
            Right newRight = new Right(rightDescription);
            this.securityCache.remove(this.securityReferenceFactory.newEntityReference((EntityReference)this.xwikiBridge.getMainWikiReference()));
            return newRight;
        }
        catch (Throwable e) {
            Right right = Right.toRight(rightDescription.getName());
            if (right != Right.ILLEGAL && right.like(rightDescription)) {
                return right;
            }
            throw new UnableToRegisterRightException(rightDescription, e);
        }
    }

    private SecurityAccess getAccess(UserSecurityReference user, SecurityReference entity) throws AuthorizationException {
        for (SecurityReference ref = entity; ref != null; ref = ref.getParentSecurityReference()) {
            SecurityRuleEntry entry = this.securityCache.get(ref);
            if (entry == null) {
                SecurityAccess access = this.securityCacheLoader.load(user, entity).getAccess();
                if (this.logger.isDebugEnabled()) {
                    Formatter f = new Formatter();
                    this.logger.debug(f.format("1. Loaded a new entry for %s@%s into cache: %s", this.entityReferenceSerializer.serialize((EntityReference)user, new Object[0]), this.entityReferenceSerializer.serialize((EntityReference)entity, new Object[0]), access).toString());
                }
                return access;
            }
            if (entry.isEmpty() && ref.getParentSecurityReference() != null) continue;
            SecurityAccessEntry accessEntry = this.securityCache.get(user, ref);
            if (accessEntry == null) {
                SecurityAccess access = this.securityCacheLoader.load(user, entity).getAccess();
                if (this.logger.isDebugEnabled()) {
                    Formatter f = new Formatter();
                    this.logger.debug(f.format("2. Loaded a new entry for %s@%s into cache: %s", this.entityReferenceSerializer.serialize((EntityReference)user, new Object[0]), this.entityReferenceSerializer.serialize((EntityReference)entity, new Object[0]), access).toString());
                }
                return access;
            }
            SecurityAccess access = accessEntry.getAccess();
            if (this.logger.isDebugEnabled()) {
                Formatter f = new Formatter();
                this.logger.debug(f.format("3. Got entry for %s@%s from cache: %s", this.entityReferenceSerializer.serialize((EntityReference)user, new Object[0]), this.entityReferenceSerializer.serialize((EntityReference)entity, new Object[0]), access).toString());
            }
            return access;
        }
        this.logger.debug("4. Returning default access level.  (This should never be reached!)");
        return XWikiSecurityAccess.getDefaultAccess();
    }

    private void logAccess(RuleState access, DocumentReference user, EntityReference entity, Right right, String info) {
        if (access == RuleState.ALLOW && this.logger.isDebugEnabled() || access != RuleState.ALLOW && this.logger.isInfoEnabled()) {
            String userName = user != null ? (String)this.entityReferenceSerializer.serialize((EntityReference)user, new Object[0]) : "no user";
            String docName = entity != null ? (String)this.entityReferenceSerializer.serialize(entity, new Object[0]) : "no entity";
            String rightName = right != null ? right.getName() : "no right";
            Formatter f = new Formatter();
            if (access == RuleState.ALLOW) {
                this.logger.debug(f.format("Access has been granted for (%s,%s,%s): %s", userName, docName, rightName, info).toString());
            } else {
                this.logger.info(f.format("Access has been denied for (%s,%s,%s): %s", userName, docName, rightName, info).toString());
            }
        }
    }

    protected void logDeny(DocumentReference user, EntityReference entity, Right right, String info) {
        this.logAccess(RuleState.DENY, user, entity, right, info);
    }
}

