/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.cache.internal;

import java.util.Collection;
import java.util.Deque;
import java.util.Formatter;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationSettler;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.cache.ConflictingInsertionException;
import org.xwiki.security.authorization.cache.ParentEntryEvictedException;
import org.xwiki.security.authorization.cache.SecurityCache;
import org.xwiki.security.authorization.cache.SecurityCacheLoader;
import org.xwiki.security.authorization.cache.SecurityCacheRulesInvalidator;
import org.xwiki.security.internal.UserBridge;

@Component
@Singleton
public class DefaultSecurityCacheLoader
implements SecurityCacheLoader {
    private static final int MAX_RETRIES = 5;
    @Inject
    private Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityCacheRulesInvalidator rulesInvalidator;
    @Inject
    private SecurityEntryReader securityEntryReader;
    @Inject
    private UserBridge userBridge;
    @Inject
    private Provider<AuthorizationSettler> authorizationSettlerProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityAccessEntry load(UserSecurityReference user, SecurityReference entity) throws AuthorizationException {
        int retries = 0;
        while (true) {
            this.rulesInvalidator.suspend();
            try {
                ++retries;
                SecurityAccessEntry securityAccessEntry = this.loadRequiredEntries(user, entity);
                return securityAccessEntry;
            }
            catch (ParentEntryEvictedException e) {
                if (retries >= 5) break;
                this.logger.debug("The parent entry was evicted. Have tried {} times.  Trying again...", (Object)retries);
                continue;
            }
            catch (ConflictingInsertionException e) {
                if (retries >= 5) break;
                this.logger.debug("There were conflicting insertions. Have tried {} times.  Retrying...", (Object)retries);
                continue;
            }
            finally {
                this.rulesInvalidator.resume();
                continue;
            }
            break;
        }
        String message = new Formatter().format("Failed to load the cache in %d attempts.  Giving up.", retries).toString();
        this.logger.error(message);
        throw new AuthorizationException(user.getOriginalDocumentReference(), entity.getOriginalReference(), message);
    }

    private SecurityAccessEntry loadRequiredEntries(UserSecurityReference user, SecurityReference entity) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        if (entity == null) {
            return ((AuthorizationSettler)this.authorizationSettlerProvider.get()).settle(user, this.loadGroupEntries(user), null);
        }
        SecurityRuleEntry entry = this.securityCache.get(entity);
        Deque<SecurityRuleEntry> ruleEntries = null;
        if (entry == null) {
            ruleEntries = this.getRules(entity);
            while ((entry = ruleEntries.getFirst()).isEmpty() && entry.getReference().getType() != EntityType.WIKI && ruleEntries.pop() != null) {
            }
        } else {
            while (entry.isEmpty() && entry.getReference().getType() != EntityType.WIKI) {
                entry = this.securityCache.get(entry.getReference().getParentSecurityReference());
            }
        }
        return this.loadAccessEntries(user, entry.getReference(), ruleEntries);
    }

    private SecurityAccessEntry loadAccessEntries(UserSecurityReference user, SecurityReference entity, Deque<SecurityRuleEntry> ruleEntries) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        Collection<GroupSecurityReference> groups = this.loadGroupEntries(user);
        if (this.securityCache.get(user) == null) {
            Deque<SecurityReference> chain = user.getReversedSecurityReferenceChain();
            chain.removeLast();
            for (SecurityReference ref : chain) {
                SecurityRuleEntry entry = this.securityCache.get(ref);
                if (entry != null) continue;
                entry = this.securityEntryReader.read(ref);
                this.securityCache.add(entry);
            }
            SecurityRuleEntry entry = this.securityEntryReader.read(user);
            this.securityCache.add(entry, groups);
        }
        Deque<SecurityRuleEntry> entries = ruleEntries == null ? this.getRules(entity) : ruleEntries;
        SecurityAccessEntry accessEntry = ((AuthorizationSettler)this.authorizationSettlerProvider.get()).settle(user, groups, entries);
        this.securityCache.add(accessEntry);
        return accessEntry;
    }

    private Collection<GroupSecurityReference> loadGroupEntries(UserSecurityReference user) throws ParentEntryEvictedException, ConflictingInsertionException, AuthorizationException {
        Collection<GroupSecurityReference> groups = this.userBridge.getAllGroupsFor(user);
        for (GroupSecurityReference group : groups) {
            this.getRules(group);
        }
        return groups;
    }

    private Deque<SecurityRuleEntry> getRules(SecurityReference entity) throws AuthorizationException, ParentEntryEvictedException, ConflictingInsertionException {
        LinkedList<SecurityRuleEntry> rules = new LinkedList<SecurityRuleEntry>();
        for (SecurityReference ref : entity.getReversedSecurityReferenceChain()) {
            SecurityRuleEntry entry = this.securityCache.get(ref);
            if (entry == null) {
                entry = this.securityEntryReader.read(ref);
                this.securityCache.add(entry);
            }
            rules.push(entry);
        }
        return rules;
    }
}

