/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.xwiki.security.authorization.Right;

public class RightSet
extends AbstractSet<Right>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long rights;

    public RightSet() {
        if (Right.size() > 64) {
            throw new IllegalStateException();
        }
    }

    public RightSet(Collection<? extends Right> rights) {
        if (Right.size() > 64) {
            throw new IllegalStateException();
        }
        this.addAll(rights);
    }

    public RightSet(Right ... rights) {
        if (Right.size() > 64) {
            throw new IllegalStateException();
        }
        Collections.addAll(this, rights);
    }

    @Override
    public Iterator<Right> iterator() {
        return new RightIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RightSet)) {
            return super.equals(o);
        }
        return ((RightSet)o).rights == this.rights;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(this.rights).hashCode();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (!(objects instanceof RightSet)) {
            return super.removeAll(objects);
        }
        long old = this.rights;
        this.rights &= ((RightSet)objects).rights ^ 0xFFFFFFFFFFFFFFFFL;
        return this.rights != old;
    }

    @Override
    public boolean add(Right right) {
        long old = this.rights;
        this.rights |= 1L << right.ordinal();
        return this.rights != old;
    }

    @Override
    public boolean addAll(Collection<? extends Right> rights) {
        if (!(rights instanceof RightSet)) {
            return super.addAll(rights);
        }
        long old = this.rights;
        this.rights |= ((RightSet)rights).rights;
        return this.rights != old;
    }

    @Override
    public void clear() {
        this.rights = 0L;
    }

    @Override
    public boolean contains(Object o) {
        return o != null && o instanceof Right && (this.rights & 1L << ((Right)o).ordinal()) != 0L;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (!(objects instanceof RightSet)) {
            return super.containsAll(objects);
        }
        return (((RightSet)objects).rights & (this.rights ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null || !(o instanceof Right)) {
            return false;
        }
        long old = this.rights;
        this.rights &= 1L << ((Right)o).ordinal() ^ 0xFFFFFFFFFFFFFFFFL;
        return this.rights != old;
    }

    @Override
    public boolean isEmpty() {
        return this.rights == 0L;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (!(objects instanceof RightSet)) {
            return super.retainAll(objects);
        }
        long old = this.rights;
        this.rights &= ((RightSet)objects).rights;
        return this.rights != old;
    }

    @Override
    public int size() {
        long v = this.rights - (this.rights >>> 1 & 0x5555555555555555L);
        v = (v & 0x3333333333333333L) + (v >>> 2 & 0x3333333333333333L);
        return (int)((v + (v >> 4) & 0xF0F0F0F0F0F0F0FL) * 0x101010101010101L >>> 56);
    }

    @Override
    public Object[] toArray() {
        return this.fillArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        Object[] a = ts;
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if (a.length > size) {
            a[size] = null;
        }
        return this.fillArray(a);
    }

    private Object[] fillArray(Object[] ts) {
        int j = 0;
        for (int i = 0; i < Right.size(); ++i) {
            if ((this.rights & (long)(1 << i)) <= 0L) continue;
            ts[j++] = Right.get(i);
        }
        return ts;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (int i = 0; i < Right.size(); ++i) {
            if ((this.rights & (long)(1 << i)) <= 0L) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(Right.get(i).getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public RightSet clone() throws CloneNotSupportedException {
        RightSet clone = (RightSet)super.clone();
        clone.rights = this.rights;
        return clone;
    }

    private class RightIterator
    implements Iterator<Right> {
        private long index;
        private long lastIndex;

        RightIterator() {
            this.index = RightSet.this.rights;
        }

        @Override
        public boolean hasNext() {
            return this.index != 0L;
        }

        @Override
        public Right next() {
            if (this.index == 0L) {
                throw new NoSuchElementException();
            }
            this.lastIndex = this.index & -this.index;
            this.index -= this.lastIndex;
            return Right.get(Long.numberOfTrailingZeros(this.lastIndex));
        }

        @Override
        public void remove() {
            if (this.lastIndex == 0L) {
                throw new IllegalStateException();
            }
            RightSet.this.rights = RightSet.this.rights - this.lastIndex;
            this.lastIndex = 0L;
        }
    }
}

