/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.user.api.XWikiUser;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authentication.api.AuthenticationConfiguration;
import org.xwiki.security.authentication.api.AuthenticationFailureEvent;
import org.xwiki.security.authentication.api.AuthenticationFailureLimitReachedEvent;
import org.xwiki.security.authentication.api.AuthenticationFailureManager;
import org.xwiki.security.authentication.api.AuthenticationFailureStrategy;

@Component
@Singleton
public class DefaultAuthenticationFailureManager
implements AuthenticationFailureManager {
    private static final String STRING_AGGREGATION_SEPARATOR = "\n";
    private static final AuthenticationFailureEvent AUTHENTICATION_FAILURE_EVENT = new AuthenticationFailureEvent();
    private static final AuthenticationFailureLimitReachedEvent AUTHENTICATION_FAILURE_LIMIT_REACHED_EVENT = new AuthenticationFailureLimitReachedEvent();
    @Inject
    private AuthenticationConfiguration configuration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    private String[] failureStrategyNames;
    private List<AuthenticationFailureStrategy> failureStrategyList;
    private Map<String, AuthFailureRecord> authFailures = new HashMap<String, AuthFailureRecord>();
    private Map<DocumentReference, String> userAndAssociatedUsernames = new HashMap<DocumentReference, String>();

    private void buildStrategyList() {
        this.failureStrategyList = new LinkedList<AuthenticationFailureStrategy>();
        for (String failureStrategyName : this.failureStrategyNames) {
            try {
                this.failureStrategyList.add((AuthenticationFailureStrategy)this.componentManager.getInstance(AuthenticationFailureStrategy.class, failureStrategyName));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Error while getting authentication failure strategy [{}]. ", (Object)failureStrategyName, (Object)e);
            }
        }
    }

    private List<AuthenticationFailureStrategy> getFailureStrategyList() {
        if (!Arrays.equals(this.configuration.getFailureStrategies(), this.failureStrategyNames)) {
            this.failureStrategyNames = this.configuration.getFailureStrategies();
            this.buildStrategyList();
        }
        return this.failureStrategyList;
    }

    private boolean isAuthenticationSecurityEnabled() {
        return this.configuration.isAuthenticationSecurityEnabled() && this.getMaxNbAttempts() != 0 && this.getMaxTime() != 0L && !this.getFailureStrategyList().isEmpty();
    }

    public boolean recordAuthenticationFailure(String username) {
        this.observationManager.notify((Event)AUTHENTICATION_FAILURE_EVENT, (Object)username);
        if (!this.isAuthenticationSecurityEnabled()) {
            this.authFailures.clear();
            return false;
        }
        if (this.authFailures.containsKey(username)) {
            this.authFailures.get(username).incrementAttemptOrReset();
        } else {
            this.authFailures.put(username, new AuthFailureRecord());
            DocumentReference userReference = this.findUser(username);
            if (userReference != null) {
                this.userAndAssociatedUsernames.put(userReference, username);
            }
        }
        boolean isThresholdReached = this.authFailures.get(username).isThresholdReached();
        if (isThresholdReached) {
            for (AuthenticationFailureStrategy authenticationFailureStrategy : this.getFailureStrategyList()) {
                authenticationFailureStrategy.notify(username);
            }
            this.observationManager.notify((Event)AUTHENTICATION_FAILURE_LIMIT_REACHED_EVENT, (Object)username);
        }
        return isThresholdReached;
    }

    public void resetAuthenticationFailureCounter(DocumentReference user) {
        if (this.userAndAssociatedUsernames.containsKey(user)) {
            this.authFailures.remove(this.userAndAssociatedUsernames.get(user));
        }
    }

    public void resetAuthenticationFailureCounter(String username) {
        this.authFailures.remove(username);
    }

    private boolean isThresholdReached(String username) {
        return this.authFailures.containsKey(username) && this.authFailures.get(username).isThresholdReached();
    }

    public String getForm(String username) {
        StringBuilder builder = new StringBuilder();
        if (this.isThresholdReached(username)) {
            for (AuthenticationFailureStrategy authenticationFailureStrategy : this.getFailureStrategyList()) {
                builder.append(authenticationFailureStrategy.getForm(username));
                builder.append(STRING_AGGREGATION_SEPARATOR);
            }
        }
        return builder.toString();
    }

    public boolean validateForm(String username, SecurityRequestWrapper request) {
        boolean result = true;
        if (!this.isAuthenticationSecurityEnabled()) {
            this.authFailures.clear();
        }
        if (this.isThresholdReached(username)) {
            for (AuthenticationFailureStrategy authenticationFailureStrategy : this.getFailureStrategyList()) {
                result = result && authenticationFailureStrategy.validateForm(username, request);
            }
        }
        if (!result) {
            ((XWikiContext)this.contextProvider.get()).put((Object)"message", (Object)"invalidcredentials");
        }
        return result;
    }

    public String getErrorMessage(String username) {
        StringBuilder builder = new StringBuilder();
        if (this.isThresholdReached(username)) {
            for (AuthenticationFailureStrategy authenticationFailureStrategy : this.getFailureStrategyList()) {
                builder.append(authenticationFailureStrategy.getErrorMessage(username));
                builder.append(STRING_AGGREGATION_SEPARATOR);
            }
        }
        return builder.toString();
    }

    private DocumentReference buildUserDocumentReference(String wikiId, String username) {
        return new DocumentReference(wikiId, "XWiki", username);
    }

    public DocumentReference findUser(String username) {
        DocumentReference result = null;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        String globalWiki = context.getMainXWiki();
        XWikiUser globalXWikiUser = new XWikiUser(this.buildUserDocumentReference(globalWiki, username));
        if (globalXWikiUser.exists(context)) {
            result = globalXWikiUser.getUserReference();
        } else {
            String localWiki = context.getWikiId();
            XWikiUser localXWikiUser = new XWikiUser(this.buildUserDocumentReference(localWiki, username));
            if (localXWikiUser.exists(context)) {
                result = localXWikiUser.getUserReference();
            }
        }
        return result;
    }

    private long getMaxTime() {
        return this.configuration.getTimeWindow() * 1000;
    }

    private int getMaxNbAttempts() {
        return this.configuration.getMaxAuthorizedAttempts();
    }

    class AuthFailureRecord {
        private long firstFailingDate = new Date().getTime();
        private int nbAttempts = 1;

        AuthFailureRecord() {
        }

        void incrementAttemptOrReset() {
            if (this.isThresholdReached()) {
                this.firstFailingDate = new Date().getTime();
                ++this.nbAttempts;
            } else if (this.firstFailingDate + DefaultAuthenticationFailureManager.this.getMaxTime() < new Date().getTime()) {
                this.firstFailingDate = new Date().getTime();
                this.nbAttempts = 1;
            } else {
                ++this.nbAttempts;
            }
        }

        boolean isThresholdReached() {
            return this.nbAttempts >= DefaultAuthenticationFailureManager.this.getMaxNbAttempts();
        }
    }
}

