/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.captcha.Captcha;
import org.xwiki.captcha.CaptchaConfiguration;
import org.xwiki.captcha.CaptchaException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.security.authentication.AuthenticationFailureStrategy;

@Component
@Named(value="captcha")
@Singleton
public class CaptchaAuthenticationFailureStrategy
implements AuthenticationFailureStrategy {
    private static final String UNEXISTING_CAPTCHA_EXCEPTION = "Invalid ID, could not validate unexisting or already validated captcha";
    @Inject
    private CaptchaConfiguration captchaConfiguration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private ContextualLocalizationManager contextLocalization;
    @Inject
    private Logger logger;

    public String getErrorMessage(String username) {
        return this.contextLocalization.getTranslationPlain("security.authentication.strategy.captcha.errorMessage", new Object[0]);
    }

    private Captcha getCaptcha() throws ComponentLookupException {
        return (Captcha)this.componentManager.getInstance(Captcha.class, this.captchaConfiguration.getDefaultName());
    }

    public String getForm(String username) {
        try {
            return this.getCaptcha().display();
        }
        catch (CaptchaException | ComponentLookupException e) {
            this.logger.error("Error while displaying the CAPTCHA.", e);
            return "";
        }
    }

    public boolean validateForm(String username, HttpServletRequest request) {
        try {
            HashMap map = new HashMap(request.getParameterMap());
            map.putAll(request.getParameterMap());
            return this.getCaptcha().isValid(map);
        }
        catch (CaptchaException | ComponentLookupException e) {
            if (UNEXISTING_CAPTCHA_EXCEPTION.equals(ExceptionUtils.getRootCause((Throwable)e).getMessage())) {
                this.logger.debug("Unexisting captcha exception", e);
            } else {
                this.logger.error("Error while validating the CAPTCHA.", e);
            }
            return false;
        }
    }

    public void notify(String username) {
    }
}

