/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.user.api.XWikiUser;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authentication.AuthenticationConfiguration;
import org.xwiki.security.authentication.AuthenticationFailureEvent;
import org.xwiki.security.authentication.AuthenticationFailureLimitReachedEvent;
import org.xwiki.security.authentication.AuthenticationFailureManager;
import org.xwiki.security.authentication.AuthenticationFailureStrategy;

@Component
@Singleton
public class DefaultAuthenticationFailureManager
implements AuthenticationFailureManager,
Initializable,
Disposable {
    private static final String STRING_AGGREGATION_SEPARATOR = "\n";
    private static final AuthenticationFailureEvent AUTHENTICATION_FAILURE_EVENT = new AuthenticationFailureEvent();
    private static final AuthenticationFailureLimitReachedEvent AUTHENTICATION_FAILURE_LIMIT_REACHED_EVENT = new AuthenticationFailureLimitReachedEvent();
    @Inject
    private AuthenticationConfiguration configuration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private Logger logger;
    private String[] failureStrategyNames;
    private List<AuthenticationFailureStrategy> failureStrategyList;
    private Map<String, AuthFailureRecord> authFailures = new HashMap<String, AuthFailureRecord>();
    private Cache<Instant> sessionFailures;
    private Map<DocumentReference, String> userAndAssociatedUsernames = new HashMap<DocumentReference, String>();

    public void initialize() throws InitializationException {
        int cacheCapacity = 100;
        try {
            this.sessionFailures = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("xwiki.security.authentication.failingSession.cache", cacheCapacity));
        }
        catch (CacheException e) {
            throw new InitializationException("Error while initializing the failing session cache.", (Throwable)e);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.sessionFailures.dispose();
    }

    private void buildStrategyList() {
        this.failureStrategyList = new LinkedList<AuthenticationFailureStrategy>();
        for (String failureStrategyName : this.failureStrategyNames) {
            try {
                this.failureStrategyList.add((AuthenticationFailureStrategy)this.componentManager.getInstance(AuthenticationFailureStrategy.class, failureStrategyName));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Error while getting authentication failure strategy [{}]. ", (Object)failureStrategyName, (Object)e);
            }
        }
    }

    private List<AuthenticationFailureStrategy> getFailureStrategyList() {
        if (!Arrays.equals(this.configuration.getFailureStrategies(), this.failureStrategyNames)) {
            this.failureStrategyNames = this.configuration.getFailureStrategies();
            this.buildStrategyList();
        }
        return this.failureStrategyList;
    }

    private boolean isAuthenticationSecurityEnabled() {
        return this.configuration.isAuthenticationSecurityEnabled() && this.getMaxNbAttempts() != 0 && this.getMaxTime() != 0L && !this.getFailureStrategyList().isEmpty();
    }

    private void clearRecords() {
        this.authFailures.clear();
        this.sessionFailures.removeAll();
    }

    private boolean skipUsername(String username) {
        return StringUtils.isEmpty((CharSequence)username);
    }

    public boolean recordAuthenticationFailure(String username, HttpServletRequest request) {
        boolean isThresholdReached;
        this.observationManager.notify((Event)AUTHENTICATION_FAILURE_EVENT, (Object)username);
        if (!this.isAuthenticationSecurityEnabled()) {
            this.clearRecords();
            return false;
        }
        if (this.skipUsername(username)) {
            return false;
        }
        if (this.authFailures.containsKey(username)) {
            this.authFailures.get(username).incrementAttemptOrReset();
        } else {
            this.authFailures.put(username, new AuthFailureRecord());
            DocumentReference userReference = this.findUser(username);
            if (userReference != null) {
                this.userAndAssociatedUsernames.put(userReference, username);
            }
        }
        if (this.isSessionAlreadyFailing(request)) {
            this.authFailures.get(username).setThresholdReached();
        }
        if (isThresholdReached = this.authFailures.get(username).isThresholdReached()) {
            for (AuthenticationFailureStrategy authenticationFailureStrategy : this.getFailureStrategyList()) {
                authenticationFailureStrategy.notify(username);
            }
            this.sessionFailures.set(request.getSession().getId(), (Object)new Date().toInstant().plus(1L, ChronoUnit.DAYS));
            this.observationManager.notify((Event)AUTHENTICATION_FAILURE_LIMIT_REACHED_EVENT, (Object)username);
        }
        return isThresholdReached;
    }

    public void resetAuthenticationFailureCounter(DocumentReference user) {
        if (this.userAndAssociatedUsernames.containsKey(user)) {
            this.authFailures.remove(this.userAndAssociatedUsernames.get(user));
        }
    }

    public void resetAuthenticationFailureCounter(String username) {
        this.authFailures.remove(username);
    }

    private boolean isThresholdReached(String username) {
        return this.authFailures.containsKey(username) && this.authFailures.get(username).isThresholdReached();
    }

    private boolean isSessionAlreadyFailing(HttpServletRequest request) {
        Instant limitDateOfAttackingSession = (Instant)this.sessionFailures.get(request.getSession().getId());
        return limitDateOfAttackingSession != null && new Date().toInstant().isBefore(limitDateOfAttackingSession);
    }

    public String getForm(String username, HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        if (!this.isAuthenticationSecurityEnabled()) {
            this.clearRecords();
        }
        if (!this.skipUsername(username) && this.isThresholdReached(username) || this.isSessionAlreadyFailing(request)) {
            for (AuthenticationFailureStrategy authenticationFailureStrategy : this.getFailureStrategyList()) {
                builder.append(authenticationFailureStrategy.getForm(username));
                builder.append(STRING_AGGREGATION_SEPARATOR);
            }
        }
        return builder.toString();
    }

    public boolean validateForm(String username, HttpServletRequest request) {
        boolean result = true;
        if (!this.isAuthenticationSecurityEnabled()) {
            this.clearRecords();
        }
        if (!this.skipUsername(username) && this.isThresholdReached(username) || this.isSessionAlreadyFailing(request)) {
            for (AuthenticationFailureStrategy authenticationFailureStrategy : this.getFailureStrategyList()) {
                result = result && authenticationFailureStrategy.validateForm(username, request);
            }
        }
        if (!result) {
            ((XWikiContext)this.contextProvider.get()).put((Object)"message", (Object)"invalidcredentials");
        }
        return result;
    }

    public String getErrorMessage(String username) {
        StringBuilder builder = new StringBuilder();
        if (!this.skipUsername(username) && this.isThresholdReached(username)) {
            for (AuthenticationFailureStrategy authenticationFailureStrategy : this.getFailureStrategyList()) {
                builder.append(authenticationFailureStrategy.getErrorMessage(username));
                builder.append(STRING_AGGREGATION_SEPARATOR);
            }
        }
        return builder.toString();
    }

    private DocumentReference buildUserDocumentReference(String wikiId, String username) {
        return new DocumentReference(wikiId, "XWiki", username);
    }

    public DocumentReference findUser(String username) {
        DocumentReference result = null;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        String globalWiki = context.getMainXWiki();
        XWikiUser globalXWikiUser = new XWikiUser(this.buildUserDocumentReference(globalWiki, username));
        if (globalXWikiUser.exists(context)) {
            result = globalXWikiUser.getUserReference();
        } else {
            String localWiki = context.getWikiId();
            XWikiUser localXWikiUser = new XWikiUser(this.buildUserDocumentReference(localWiki, username));
            if (localXWikiUser.exists(context)) {
                result = localXWikiUser.getUserReference();
            }
        }
        return result;
    }

    private long getMaxTime() {
        return this.configuration.getTimeWindow() * 1000;
    }

    private int getMaxNbAttempts() {
        return this.configuration.getMaxAuthorizedAttempts();
    }

    class AuthFailureRecord {
        private long firstFailingDate = new Date().getTime();
        private int nbAttempts = 1;

        AuthFailureRecord() {
        }

        void incrementAttemptOrReset() {
            if (this.isThresholdReached()) {
                this.firstFailingDate = new Date().getTime();
                ++this.nbAttempts;
            } else if (this.firstFailingDate + DefaultAuthenticationFailureManager.this.getMaxTime() < new Date().getTime()) {
                this.firstFailingDate = new Date().getTime();
                this.nbAttempts = 1;
            } else {
                ++this.nbAttempts;
            }
        }

        void setThresholdReached() {
            this.nbAttempts = DefaultAuthenticationFailureManager.this.getMaxNbAttempts();
        }

        boolean isThresholdReached() {
            return this.nbAttempts >= DefaultAuthenticationFailureManager.this.getMaxNbAttempts();
        }
    }
}

