/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PasswordClass;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.security.authentication.AuthenticationAction;
import org.xwiki.security.authentication.AuthenticationResourceReference;
import org.xwiki.security.authentication.ResetPasswordException;
import org.xwiki.security.authentication.ResetPasswordManager;
import org.xwiki.security.authentication.ResetPasswordRequestResponse;
import org.xwiki.security.authentication.internal.DefaultResetPasswordRequestResponse;
import org.xwiki.security.authentication.internal.ResetPasswordMailSender;
import org.xwiki.url.ExtendedURL;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Singleton
public class DefaultResetPasswordManager
implements ResetPasswordManager {
    protected static final String XWIKI_SPACE = "XWiki";
    protected static final LocalDocumentReference LDAP_CLASS_REFERENCE = new LocalDocumentReference("XWiki", "LDAPProfileClass");
    protected static final LocalDocumentReference RESET_PASSWORD_REQUEST_CLASS_REFERENCE = new LocalDocumentReference("XWiki", "ResetPasswordRequestClass");
    protected static final LocalDocumentReference USER_CLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiUsers");
    protected static final String VERIFICATION_PROPERTY = "verification";
    @Inject
    private UserManager userManager;
    @Inject
    private UserPropertiesResolver userPropertiesResolver;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ResourceReferenceSerializer<ResourceReference, ExtendedURL> resourceReferenceSerializer;
    @Inject
    private UserReferenceSerializer<String> referenceSerializer;
    @Inject
    private Provider<ResetPasswordMailSender> resetPasswordMailSenderProvider;

    private void checkUserReference(UserReference userReference) throws ResetPasswordException {
        if (!this.userManager.exists(userReference)) {
            String exceptionMessage = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.error.noUser", new Object[]{userReference.toString()});
            throw new ResetPasswordException(exceptionMessage);
        }
        if (!(userReference instanceof DocumentUserReference)) {
            throw new ResetPasswordException("Only user having a page on the wiki can reset their password.");
        }
    }

    public ResetPasswordRequestResponse requestResetPassword(UserReference userReference) throws ResetPasswordException {
        this.checkUserReference(userReference);
        UserProperties userProperties = this.userPropertiesResolver.resolve(userReference, new Object[0]);
        InternetAddress email = userProperties.getEmail();
        if (email == null) {
            String exceptionMessage = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.error.noEmail", new Object[0]);
            throw new ResetPasswordException(exceptionMessage);
        }
        DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
        DocumentReference reference = documentUserReference.getReference();
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument userDocument = context.getWiki().getDocument(reference, context);
            if (userDocument.getXObject((EntityReference)LDAP_CLASS_REFERENCE) != null) {
                String exceptionMessage = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.error.ldapUser", new Object[]{userReference.toString()});
                throw new ResetPasswordException(exceptionMessage);
            }
            BaseObject xObject = userDocument.getXObject((EntityReference)RESET_PASSWORD_REQUEST_CLASS_REFERENCE, true, context);
            String verificationCode = context.getWiki().generateRandomString(30);
            xObject.set(VERIFICATION_PROPERTY, (Object)verificationCode, context);
            String saveComment = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.versionComment", new Object[0]);
            context.getWiki().saveDocument(userDocument, saveComment, true, context);
            return new DefaultResetPasswordRequestResponse(userReference, email, verificationCode);
        }
        catch (XWikiException e) {
            throw new ResetPasswordException("Error when reading user document to perform reset password request.", (Throwable)e);
        }
    }

    public void sendResetPasswordEmailRequest(ResetPasswordRequestResponse requestResponse) throws ResetPasswordException {
        AuthenticationResourceReference resourceReference = new AuthenticationResourceReference(AuthenticationAction.RESET_PASSWORD);
        UserReference userReference = requestResponse.getUserReference();
        UserProperties userProperties = this.userPropertiesResolver.resolve(userReference, new Object[0]);
        String serializedUserReference = (String)this.referenceSerializer.serialize(userReference);
        String formattedName = "";
        if (!StringUtils.isBlank((CharSequence)userProperties.getFirstName())) {
            formattedName = formattedName + userProperties.getFirstName();
        }
        if (!StringUtils.isBlank((CharSequence)userProperties.getLastName())) {
            if (!StringUtils.isBlank((CharSequence)formattedName)) {
                formattedName = formattedName + " ";
            }
            formattedName = formattedName + userProperties.getLastName();
        }
        if (StringUtils.isBlank((CharSequence)formattedName)) {
            formattedName = serializedUserReference;
        }
        resourceReference.addParameter("u", (Object)serializedUserReference);
        resourceReference.addParameter("v", (Object)requestResponse.getVerificationCode());
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        ExtendedURL extendedURL = null;
        try {
            extendedURL = (ExtendedURL)this.resourceReferenceSerializer.serialize((ResourceReference)resourceReference);
            URL serverURL = context.getURLFactory().getServerURL(context);
            URL externalVerificationURL = new URL(serverURL, extendedURL.serialize());
            ((ResetPasswordMailSender)this.resetPasswordMailSenderProvider.get()).sendResetPasswordEmail(formattedName, requestResponse.getUserEmail(), externalVerificationURL);
        }
        catch (MalformedURLException | SerializeResourceReferenceException | UnsupportedResourceReferenceException e) {
            throw new ResetPasswordException("Error when processing information for creating the email.", e);
        }
    }

    public ResetPasswordRequestResponse checkVerificationCode(UserReference userReference, String verificationCode) throws ResetPasswordException {
        this.checkUserReference(userReference);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        UserProperties userProperties = this.userPropertiesResolver.resolve(userReference, new Object[0]);
        InternetAddress email = userProperties.getEmail();
        DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
        DocumentReference reference = documentUserReference.getReference();
        String exceptionMessage = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.step2.error.wrongParameters", new Object[]{userReference.toString()});
        try {
            XWikiDocument userDocument = context.getWiki().getDocument(reference, context);
            BaseObject xObject = userDocument.getXObject((EntityReference)RESET_PASSWORD_REQUEST_CLASS_REFERENCE);
            if (xObject == null) {
                throw new ResetPasswordException(exceptionMessage);
            }
            String storedVerificationCode = xObject.getStringValue(VERIFICATION_PROPERTY);
            BaseClass xClass = xObject.getXClass(context);
            PropertyInterface verification = xClass.get(VERIFICATION_PROPERTY);
            if (!(verification instanceof PasswordClass)) {
                throw new ResetPasswordException("Bad definition of ResetPassword XClass.");
            }
            PasswordClass passwordClass = (PasswordClass)verification;
            String equivalentPassword = passwordClass.getEquivalentPassword(storedVerificationCode, verificationCode);
            String newVerificationCode = context.getWiki().generateRandomString(30);
            xObject.set(VERIFICATION_PROPERTY, (Object)newVerificationCode, context);
            String saveComment = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.step2.versionComment.changeValidationKey", new Object[0]);
            context.getWiki().saveDocument(userDocument, saveComment, true, context);
            if (!storedVerificationCode.equals(equivalentPassword)) {
                throw new ResetPasswordException(exceptionMessage);
            }
            return new DefaultResetPasswordRequestResponse(userReference, email, newVerificationCode);
        }
        catch (XWikiException e) {
            throw new ResetPasswordException("Cannot open user document to check verification code.", (Throwable)e);
        }
    }

    public void resetPassword(UserReference userReference, String newPassword) throws ResetPasswordException {
        this.checkUserReference(userReference);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
        DocumentReference reference = documentUserReference.getReference();
        try {
            XWikiDocument userDocument = context.getWiki().getDocument(reference, context);
            userDocument.removeXObjects((EntityReference)RESET_PASSWORD_REQUEST_CLASS_REFERENCE);
            BaseObject userXObject = userDocument.getXObject((EntityReference)USER_CLASS_REFERENCE);
            userXObject.setStringValue("password", newPassword);
            String saveComment = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.step2.versionComment.passwordReset", new Object[0]);
            context.getWiki().saveDocument(userDocument, saveComment, true, context);
        }
        catch (XWikiException e) {
            throw new ResetPasswordException("Cannot open user document to perform reset password.", (Throwable)e);
        }
    }
}

