/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.user.api.XWikiUser;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authentication.AuthenticationFailureManager;
import org.xwiki.security.authentication.AuthenticationFailureStrategy;

@Component
@Named(value="disableAccount")
@Singleton
public class DisableAccountFailureStrategy
implements AuthenticationFailureStrategy,
EventListener {
    public static final String NAME = "disableAccount";
    protected static final LocalDocumentReference USER_CLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiUsers");
    @Inject
    private ContextualLocalizationManager contextLocalization;
    @Inject
    private Provider<AuthenticationFailureManager> authenticationFailureManager;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public String getErrorMessage(String username) {
        return this.contextLocalization.getTranslationPlain("security.authentication.strategy.disableAccount.errorMessage", new Object[0]);
    }

    public String getForm(String username) {
        return "";
    }

    public boolean validateForm(String username, HttpServletRequest request) {
        DocumentReference userDocumentReference = ((AuthenticationFailureManager)this.authenticationFailureManager.get()).findUser(username);
        if (userDocumentReference != null) {
            return !new XWikiUser(userDocumentReference).isDisabled((XWikiContext)this.contextProvider.get());
        }
        return false;
    }

    public void notify(String username) {
        DocumentReference userDocumentReference = ((AuthenticationFailureManager)this.authenticationFailureManager.get()).findUser(username);
        if (userDocumentReference != null) {
            new XWikiUser(userDocumentReference).setDisabled(true, (XWikiContext)this.contextProvider.get());
        }
    }

    public List<Event> getEvents() {
        return Collections.singletonList(new DocumentUpdatedEvent());
    }

    public String getName() {
        return NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument updatedDocument = (XWikiDocument)source;
        BaseObject updatedUserObject = updatedDocument.getXObject((EntityReference)USER_CLASS_REFERENCE);
        XWikiDocument originalDocument = updatedDocument.getOriginalDocument();
        BaseObject originalUserObject = originalDocument.getXObject((EntityReference)USER_CLASS_REFERENCE);
        if (originalUserObject != null && updatedUserObject != null && this.propertyValueChanged(originalUserObject, updatedUserObject, "active", 1)) {
            ((AuthenticationFailureManager)this.authenticationFailureManager.get()).resetAuthenticationFailureCounter(updatedDocument.getDocumentReference());
        }
    }

    private boolean propertyValueChanged(BaseObject originalObject, BaseObject updatedObject, String propertyName, int expectedValue) {
        return originalObject.getIntValue(propertyName) != expectedValue && updatedObject.getIntValue(propertyName) == expectedValue;
    }
}

