/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusResult;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.SessionFactory;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.security.authentication.ResetPasswordException;

@Component(roles={ResetPasswordMailSender.class})
@Singleton
public class ResetPasswordMailSender {
    private static final LocalDocumentReference RESET_PASSWORD_MAIL_TEMPLATE_REFERENCE = new LocalDocumentReference("XWiki", "ResetPasswordMailContent");
    @Inject
    private MailSenderConfiguration mailSenderConfiguration;
    @Inject
    private DocumentReferenceResolver<EntityReference> documentReferenceResolver;
    @Inject
    @Named(value="template")
    private MimeMessageFactory<MimeMessage> mimeMessageFactory;
    @Inject
    private MailSender mailSender;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="database")
    private Provider<MailListener> mailListenerProvider;

    public void sendResetPasswordEmail(String username, InternetAddress email, URL resetPasswordURL) throws ResetPasswordException {
        MimeMessage message;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        String fromAddress = this.mailSenderConfiguration.getFromAddress();
        if (StringUtils.isEmpty((CharSequence)fromAddress)) {
            fromAddress = "no-reply@" + context.getRequest().getServerName();
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("from", fromAddress);
        parameters.put("to", email);
        parameters.put("language", context.getLocale());
        parameters.put("type", "Reset Password");
        HashMap<String, String> velocityVariables = new HashMap<String, String>();
        velocityVariables.put("userName", username);
        velocityVariables.put("passwordResetURL", resetPasswordURL.toExternalForm());
        parameters.put("velocityVariables", velocityVariables);
        String localizedError = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.error.emailFailed", new Object[0]);
        try {
            message = (MimeMessage)this.mimeMessageFactory.createMessage((Object)this.documentReferenceResolver.resolve((Object)RESET_PASSWORD_MAIL_TEMPLATE_REFERENCE, new Object[0]), parameters);
        }
        catch (MessagingException e) {
            throw new ResetPasswordException(localizedError, (Throwable)e);
        }
        MailListener mailListener = (MailListener)this.mailListenerProvider.get();
        this.mailSender.sendAsynchronously(Collections.singleton(message), this.sessionFactory.create(Collections.emptyMap()), mailListener);
        MailStatusResult mailStatusResult = mailListener.getMailStatusResult();
        mailStatusResult.waitTillProcessed(30L);
        Iterator mailErrors = mailStatusResult.getAllErrors();
        if (mailErrors != null && mailErrors.hasNext()) {
            MailStatus lastError = (MailStatus)mailErrors.next();
            throw new ResetPasswordException(String.format("%s - %s", localizedError, lastError.getErrorDescription()));
        }
    }
}

