/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal.resource;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiContextInitializer;
import com.xpn.xwiki.web.Utils;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.security.authentication.AuthenticationResourceReference;

@Component
@Named(value="authenticate")
@Singleton
public class AuthenticationResourceReferenceHandler
extends AbstractResourceReferenceHandler<ResourceType> {
    @Inject
    private XWikiContextInitializer xWikiContextInitializer;
    @Inject
    private Execution execution;

    public List<ResourceType> getSupportedResourceReferences() {
        return Collections.singletonList(AuthenticationResourceReference.TYPE);
    }

    public void handle(ResourceReference reference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        AuthenticationResourceReference authenticationResourceReference = (AuthenticationResourceReference)reference;
        switch (authenticationResourceReference.getAction()) {
            case FORGOT_USERNAME: {
                this.handleAction("forgotusername");
                break;
            }
            case RESET_PASSWORD: {
                this.handleAction("resetpassword");
                break;
            }
        }
        chain.handleNext(reference);
    }

    private void handleAction(String templateName) throws ResourceReferenceHandlerException {
        ExecutionContext context = this.execution.getContext();
        if (context == null) {
            context = new ExecutionContext();
        }
        try {
            XWikiContext xWikiContext = this.xWikiContextInitializer.initialize(context);
            Utils.parseTemplate((String)templateName, (boolean)true, (XWikiContext)xWikiContext);
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Error while rendering template [%s]: [%s].", templateName, ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
        }
    }
}

