/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.internal.EntityBridge;

@Component
@Singleton
public class DefaultEntityBridge
implements EntityBridge {
    @Inject
    private Execution execution;

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public boolean isDocumentCreator(UserSecurityReference user, SecurityReference entity) {
        XWikiDocument document;
        if (user == null || entity == null) {
            return false;
        }
        DocumentReference documentReference = entity.getOriginalDocumentReference();
        if (documentReference == null) {
            return false;
        }
        XWikiContext context = this.getXWikiContext();
        try {
            document = context.getWiki().getDocument(documentReference, context);
        }
        catch (XWikiException e) {
            return false;
        }
        if (document == null) {
            return false;
        }
        DocumentReference creator = document.getCreatorReference();
        return user.getOriginalReference().equals((Object)creator);
    }
}

