/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.user.api.XWikiGroupService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReferenceFactory;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.internal.UserBridge;

@Component
@Singleton
public class DefaultUserBridge
implements UserBridge {
    @Inject
    private SecurityReferenceFactory factory;
    @Inject
    private Execution execution;

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public Collection<GroupSecurityReference> getAllGroupsFor(UserSecurityReference user) throws AuthorizationException {
        Collection<DocumentReference> groupRefs = this.getGroupsReferencesFor(user.getOriginalReference().getWikiReference(), user.getOriginalReference());
        ArrayList<GroupSecurityReference> groups = new ArrayList<GroupSecurityReference>(groupRefs.size());
        for (DocumentReference groupRef : groupRefs) {
            GroupSecurityReference group = this.factory.newGroupReference(groupRef);
            groups.add(group);
        }
        return groups;
    }

    private Collection<DocumentReference> getGroupsReferencesFor(WikiReference wiki, DocumentReference userOrGroupDocumentReference) throws AuthorizationException {
        XWikiGroupService groupService;
        XWikiContext xwikiContext = this.getXWikiContext();
        try {
            groupService = xwikiContext.getWiki().getGroupService(xwikiContext);
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to access the group service.", (Throwable)e);
        }
        String currentWiki = xwikiContext.getDatabase();
        try {
            xwikiContext.setDatabase(wiki.getName());
            Collection collection = groupService.getAllGroupsReferencesForMember(userOrGroupDocumentReference, 0, 0, xwikiContext);
            return collection;
        }
        catch (Exception e) {
            throw new AuthorizationException(new Formatter().format("Failed to get groups for user or group [%s] in wiki [%s]", userOrGroupDocumentReference, wiki).toString(), (Throwable)e);
        }
        finally {
            xwikiContext.setDatabase(currentWiki);
        }
    }
}

