/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.EntityTypeNotSupportedException;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.internal.AbstractSecurityRuleEntry;
import org.xwiki.security.authorization.internal.XWikiSecurityRule;

@Component
@Singleton
public class DefaultSecurityEntryReader
implements SecurityEntryReader {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="user")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private Execution execution;

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public SecurityRuleEntry read(SecurityReference entity) throws AuthorizationException {
        List baseObjects;
        DocumentReference classReference;
        DocumentReference documentReference;
        WikiReference wikiReference;
        switch (entity.getType()) {
            case WIKI: {
                wikiReference = new WikiReference((EntityReference)entity);
                SpaceReference wikiSpace = new SpaceReference("XWiki", wikiReference);
                documentReference = new DocumentReference("XWikiPreferences", wikiSpace);
                classReference = new DocumentReference("XWikiGlobalRights", wikiSpace);
                break;
            }
            case SPACE: {
                wikiReference = new WikiReference(entity.extractReference(EntityType.WIKI));
                documentReference = new DocumentReference("WebPreferences", new SpaceReference((EntityReference)entity));
                classReference = new DocumentReference("XWikiGlobalRights", new SpaceReference("XWiki", wikiReference));
                break;
            }
            default: {
                EntityReference relatedDocument = entity.extractReference(EntityType.DOCUMENT);
                if (relatedDocument != null) {
                    wikiReference = new WikiReference(relatedDocument.extractReference(EntityType.WIKI));
                    documentReference = new DocumentReference(relatedDocument);
                    classReference = new DocumentReference("XWikiRights", new SpaceReference("XWiki", wikiReference));
                    break;
                }
                this.logger.debug("Rights on entities of type {} is not supported by this reader!", (Object)entity.getType());
                throw new EntityTypeNotSupportedException(entity.getType(), (SecurityEntryReader)this);
            }
        }
        XWikiContext context = this.getXWikiContext();
        ArrayList<XWikiSecurityRule> securityRules = new ArrayList<XWikiSecurityRule>();
        try {
            XWikiDocument doc = context.getWiki().getDocument(documentReference, context);
            if (doc == null) {
                return new InternalSecurityRuleEntry(entity, Collections.emptyList());
            }
            baseObjects = doc.getXObjects(classReference);
        }
        catch (XWikiException e) {
            throw new AuthorizationException((EntityReference)documentReference, "Couldn't read right objects", (Throwable)e);
        }
        if (baseObjects != null) {
            for (BaseObject obj : baseObjects) {
                if (obj == null) continue;
                securityRules.add(new XWikiSecurityRule(obj, this.resolver, wikiReference));
            }
        }
        return new InternalSecurityRuleEntry(entity, securityRules);
    }

    private final class InternalSecurityRuleEntry
    extends AbstractSecurityRuleEntry {
        private final SecurityReference reference;
        private final Collection<SecurityRule> rules;

        private InternalSecurityRuleEntry(SecurityReference reference, Collection<SecurityRule> rules) {
            this.reference = reference;
            this.rules = Collections.unmodifiableCollection(rules);
        }

        public SecurityReference getReference() {
            return this.reference;
        }

        public Collection<SecurityRule> getRules() {
            return this.rules;
        }
    }
}

