/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.GroupsClass;
import com.xpn.xwiki.objects.classes.UsersClass;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightSet;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.text.XWikiToStringStyle;

public class XWikiSecurityRule
implements SecurityRule {
    private final Set<DocumentReference> users;
    private final Set<DocumentReference> groups;
    private final RightSet rights;
    private final RuleState state;

    protected XWikiSecurityRule(BaseObject obj, DocumentReferenceResolver<String> resolver, WikiReference wikiReference) {
        String[] levelsarray;
        this.state = obj.getIntValue("allow") == 1 ? RuleState.ALLOW : RuleState.DENY;
        this.users = new HashSet<DocumentReference>();
        this.groups = new HashSet<DocumentReference>();
        this.rights = new RightSet();
        String levels = obj.getStringValue("levels");
        for (String s : levelsarray = StringUtils.split((String)levels, (String)" ,|")) {
            Right right = Right.toRight((String)s);
            if (right == Right.ILLEGAL) continue;
            this.rights.add(right);
        }
        for (String user : UsersClass.getListFromString((String)obj.getStringValue("users"))) {
            DocumentReference ref = resolver.resolve((Object)user, new Object[]{wikiReference});
            this.users.add(ref);
        }
        for (String group : GroupsClass.getListFromString((String)obj.getStringValue("groups"))) {
            DocumentReference ref = resolver.resolve((Object)group, new Object[]{wikiReference});
            this.groups.add(ref);
        }
    }

    protected XWikiSecurityRule(RightSet rights, RuleState state, Set<DocumentReference> users, Set<DocumentReference> groups) {
        this.users = users;
        this.groups = groups;
        this.rights = rights;
        this.state = state;
    }

    public boolean match(Right right) {
        return this.rights.contains((Object)right);
    }

    public boolean match(GroupSecurityReference group) {
        return this.groups.contains(group.getOriginalReference());
    }

    public boolean match(UserSecurityReference user) {
        return this.users.contains(user.getOriginalReference());
    }

    public RuleState getState() {
        return this.state;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        XWikiSecurityRule other = (XWikiSecurityRule)object;
        return this.state == other.state && this.rights.equals((Object)other.rights) && ((Object)this.users).equals(other.users) && ((Object)this.groups).equals(other.groups);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.state).append((Object)this.rights).append(this.users).append(this.groups).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, (ToStringStyle)new XWikiToStringStyle());
        return builder.append("State", (Object)this.state).append("Rights", (Object)this.rights).append("Users", this.users).append("Groups", this.groups).toString();
    }
}

