/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.EntityTypeNotSupportedException;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightSet;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.internal.AbstractSecurityRuleEntry;
import org.xwiki.security.authorization.internal.AllowEditToNoOneRule;
import org.xwiki.security.authorization.internal.XWikiSecurityRule;

@Component
@Singleton
public class DefaultSecurityEntryReader
implements SecurityEntryReader {
    private static final SecurityRule DENY_EDIT = new AllowEditToNoOneRule();
    private static final Set<Right> OWNER_RIGHTS = new RightSet(new Right[]{Right.ADMIN});
    private static final Set<Right> CREATOR_RIGHTS = new RightSet(new Right[]{Right.CREATOR});
    @Inject
    private Logger logger;
    @Inject
    @Named(value="user")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private Execution execution;

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public SecurityRuleEntry read(SecurityReference entity) throws AuthorizationException {
        DocumentReference classReference;
        DocumentReference documentReference;
        WikiReference wikiReference;
        if (entity == null) {
            return null;
        }
        if (entity.getOriginalReference() == null) {
            return new InternalSecurityRuleEntry(entity, Collections.emptyList());
        }
        switch (entity.getType()) {
            case WIKI: {
                wikiReference = new WikiReference((EntityReference)entity);
                SpaceReference wikiSpace = new SpaceReference("XWiki", wikiReference);
                documentReference = new DocumentReference("XWikiPreferences", wikiSpace);
                classReference = new DocumentReference("XWikiGlobalRights", wikiSpace);
                break;
            }
            case SPACE: {
                wikiReference = new WikiReference(entity.extractReference(EntityType.WIKI));
                documentReference = new DocumentReference("WebPreferences", new SpaceReference((EntityReference)entity));
                classReference = new DocumentReference("XWikiGlobalRights", new SpaceReference("XWiki", wikiReference));
                break;
            }
            default: {
                EntityReference relatedDocument = entity.extractReference(EntityType.DOCUMENT);
                if (relatedDocument != null) {
                    wikiReference = new WikiReference(relatedDocument.extractReference(EntityType.WIKI));
                    documentReference = new DocumentReference(relatedDocument);
                    classReference = new DocumentReference("XWikiRights", new SpaceReference("XWiki", wikiReference));
                    break;
                }
                this.logger.debug("Rights on entities of type {} is not supported by this reader!", (Object)entity.getType());
                throw new EntityTypeNotSupportedException(entity.getType(), (SecurityEntryReader)this);
            }
        }
        return new InternalSecurityRuleEntry(entity, this.getSecurityRules(documentReference, classReference, wikiReference));
    }

    private XWikiDocument getDocument(DocumentReference documentReference) throws AuthorizationException {
        XWikiContext context = this.getXWikiContext();
        try {
            XWikiDocument doc = context.getWiki().getDocument(documentReference, context);
            if (doc == null || doc.isNew()) {
                return null;
            }
            return doc;
        }
        catch (XWikiException e) {
            throw new AuthorizationException((EntityReference)documentReference, "Could not retrieve the document to check security access", (Throwable)e);
        }
    }

    private DocumentReference getWikiOwner(WikiReference wikiReference) throws AuthorizationException {
        String wikiOwner;
        XWikiContext context = this.getXWikiContext();
        try {
            wikiOwner = context.getWiki().getWikiOwner(wikiReference.getName(), context);
        }
        catch (XWikiException e) {
            throw new AuthorizationException((EntityReference)wikiReference, "Could not retrieve the owner of this wiki", (Throwable)e);
        }
        if (wikiOwner == null) {
            return null;
        }
        return this.resolver.resolve((Object)wikiOwner, new Object[]{wikiReference});
    }

    private Collection<SecurityRule> getSecurityRules(DocumentReference documentReference, DocumentReference classReference, WikiReference wikiReference) throws AuthorizationException {
        boolean isGlobalRightsReference = this.isGlobalRightsReference(documentReference);
        boolean isGlobalRightRequested = classReference.getName().equals("XWikiGlobalRights");
        XWikiDocument doc = this.getDocument(documentReference);
        List<SecurityRule> securityRules = this.getImpliedRules(documentReference, doc, isGlobalRightsReference, isGlobalRightRequested);
        if (doc == null) {
            return securityRules;
        }
        List baseObjects = doc.getXObjects(classReference);
        if (baseObjects != null) {
            for (BaseObject obj : baseObjects) {
                SecurityRule rule;
                if (obj == null) continue;
                try {
                    rule = XWikiSecurityRule.createNewRule(obj, this.resolver, wikiReference, isGlobalRightsReference && !isGlobalRightRequested);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                securityRules.add(rule);
            }
        }
        return securityRules;
    }

    private List<SecurityRule> getImpliedRules(DocumentReference documentReference, XWikiDocument document, boolean isGlobalRightsReference, boolean isGlobalRightRequested) throws AuthorizationException {
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        if (isGlobalRightsReference) {
            if (isGlobalRightRequested) {
                DocumentReference owner = this.getWikiOwner(documentReference.getWikiReference());
                if (owner != null) {
                    rules.add(new XWikiSecurityRule(OWNER_RIGHTS, RuleState.ALLOW, Collections.singleton(owner), null));
                }
            } else {
                rules.add(DENY_EDIT);
            }
        }
        if (!isGlobalRightRequested && document != null) {
            rules.add(new XWikiSecurityRule(CREATOR_RIGHTS, RuleState.ALLOW, Collections.singleton(document.getCreatorReference()), null));
        }
        return rules;
    }

    private boolean isGlobalRightsReference(DocumentReference documentReference) {
        return "WebPreferences".equals(documentReference.getName()) || "XWikiPreferences".equals(documentReference.getName()) && "XWiki".equals(documentReference.getParent().getName());
    }

    private final class InternalSecurityRuleEntry
    extends AbstractSecurityRuleEntry {
        private final SecurityReference reference;
        private final Collection<SecurityRule> rules;

        private InternalSecurityRuleEntry(SecurityReference reference, Collection<SecurityRule> rules) {
            this.reference = reference;
            this.rules = Collections.unmodifiableCollection(rules);
        }

        public SecurityReference getReference() {
            return this.reference;
        }

        public Collection<SecurityRule> getRules() {
            return this.rules;
        }
    }
}

