/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

@Component(hints={"user", "group"})
@Singleton
public class UserAndGroupReferenceResolver
implements DocumentReferenceResolver<String> {
    @Inject
    private EntityReferenceResolver<String> resolver;

    public DocumentReference resolve(String documentReferenceRepresentation, Object ... parameters) {
        EntityReference defaultSpace;
        if (parameters.length > 0 && !(parameters[0] instanceof EntityReference)) {
            throw new IllegalArgumentException("This resolver accept only a single parameter of type WikiReference.");
        }
        if (parameters.length > 0) {
            EntityReference defaultWiki = ((EntityReference)parameters[0]).extractReference(EntityType.WIKI);
            defaultSpace = new EntityReference("XWiki", EntityType.SPACE, defaultWiki);
        } else {
            defaultSpace = this.resolver.resolve((Object)"XWiki", EntityType.SPACE, new Object[0]);
        }
        return new DocumentReference(this.resolver.resolve((Object)documentReferenceRepresentation, EntityType.DOCUMENT, new Object[]{defaultSpace}));
    }
}

