/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.internal.XWikiBridge;

@Component
@Singleton
public class DefaultXWikiBridge
implements XWikiBridge {
    @Inject
    @Named(value="user")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private WikiReference mainWikiReference;

    public WikiReference getMainWikiReference() {
        if (this.mainWikiReference == null) {
            this.mainWikiReference = new WikiReference(((XWikiContext)this.xcontextProvider.get()).getMainXWiki());
        }
        return this.mainWikiReference;
    }

    public boolean isWikiReadOnly() {
        return ((XWikiContext)this.xcontextProvider.get()).getWiki().isReadOnly();
    }

    public boolean needsAuthentication(Right right) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        String prefName = "authenticate_" + right.getName();
        String value = context.getWiki().getXWikiPreference(prefName, "", context);
        Boolean result = this.checkNeedsAuthValue(value);
        if (result != null) {
            return result;
        }
        value = context.getWiki().getSpacePreference(prefName, "", context).toLowerCase();
        result = this.checkNeedsAuthValue(value);
        if (result != null) {
            return result;
        }
        return false;
    }

    private Boolean checkNeedsAuthValue(String value) {
        if (value != null && !value.equals("")) {
            if (value.toLowerCase().equals("yes")) {
                return true;
            }
            try {
                if (Integer.parseInt(value) > 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

