/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web.sx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.debug.DebugConfiguration;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.sx.Extension;
import com.xpn.xwiki.web.sx.SxDocumentSource;
import com.xpn.xwiki.web.sx.SxResourceSource;
import com.xpn.xwiki.web.sx.SxSource;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;

public abstract class AbstractSxAction
extends XWikiAction {
    private static final long LONG_CACHE_DURATION = 2592000000L;
    private static final long SHORT_CACHE_DURATION = 86400000L;
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CACHE_EXPIRES_HEADER = "Expires";
    private static final String RESPONSE_CHARACTER_SET = "UTF-8";
    private static final String JAR_RESOURCE_REQUEST_PARAMETER = "resource";
    private DebugConfiguration debugConfiguration;

    protected abstract Logger getLogger();

    public void renderExtension(SxSource sxSource, Extension sxType, XWikiContext context) throws XWikiException {
        SxSource.CachePolicy cachePolicy;
        XWikiResponse response = context.getResponse();
        String extensionContent = sxSource.getContent();
        response.setContentType(sxType.getContentType());
        if (sxSource.getLastModifiedDate() > 0L) {
            response.setDateHeader(LAST_MODIFIED_HEADER, sxSource.getLastModifiedDate());
        }
        if ((cachePolicy = sxSource.getCachePolicy()) != SxSource.CachePolicy.FORBID) {
            response.setHeader(CACHE_CONTROL_HEADER, "public");
        }
        if (cachePolicy == SxSource.CachePolicy.LONG) {
            response.setDateHeader(CACHE_EXPIRES_HEADER, new Date().getTime() + 2592000000L);
        } else if (cachePolicy == SxSource.CachePolicy.SHORT) {
            response.setDateHeader(CACHE_EXPIRES_HEADER, new Date().getTime() + 86400000L);
        } else if (cachePolicy == SxSource.CachePolicy.FORBID) {
            response.setHeader(CACHE_CONTROL_HEADER, "no-cache, no-store, must-revalidate");
        }
        if (this.getDebugConfiguration().isMinify()) {
            extensionContent = sxType.getCompressor().compress(extensionContent);
        }
        try {
            response.setContentLength(extensionContent.getBytes(RESPONSE_CHARACTER_SET).length);
            response.getOutputStream().write(extensionContent.getBytes(RESPONSE_CHARACTER_SET));
        }
        catch (IOException ex) {
            this.getLogger().warn("Failed to send SX content: [{}]", (Object)ex.getMessage());
        }
    }

    public String render(XWikiContext context) throws XWikiException {
        SxSource sxSource;
        if (context.getRequest().getParameter(JAR_RESOURCE_REQUEST_PARAMETER) != null) {
            sxSource = new SxResourceSource(context.getRequest().getParameter(JAR_RESOURCE_REQUEST_PARAMETER));
        } else {
            if (context.getDoc().isNew()) {
                context.getResponse().setStatus(404);
                return "docdoesnotexist";
            }
            sxSource = new SxDocumentSource(context, this.getExtensionType());
        }
        try {
            this.renderExtension(sxSource, this.getExtensionType(), context);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            context.getResponse().setStatus(404);
        }
        return null;
    }

    protected DebugConfiguration getDebugConfiguration() {
        if (this.debugConfiguration == null) {
            this.debugConfiguration = (DebugConfiguration)Utils.getComponent(DebugConfiguration.class);
        }
        return this.debugConfiguration;
    }

    public abstract Extension getExtensionType();
}

