/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.web.XWikiURLFactory;
import com.xpn.xwiki.web.sx.AbstractSxAction;
import com.xpn.xwiki.web.sx.Extension;
import com.xpn.xwiki.web.sx.JsExtension;
import com.xpn.xwiki.web.sx.SxCompressor;
import com.xpn.xwiki.web.sx.SxSource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="jsx")
@Singleton
public class JsxAction
extends AbstractSxAction {
    public static final JsExtension JSX = new JsExtension();
    private static final Logger LOGGER = LoggerFactory.getLogger(JsxAction.class);
    private static final String SOURCE_MAPS_SESSION_ATTRIBUTE = String.valueOf(JsxAction.class.getName()) + ".sourceMaps";
    private static final String SOURCE_MAP_PARAMS = "sourceMap=true&minify=false";

    @Override
    public Extension getExtensionType() {
        return JSX;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public void renderExtension(final SxSource sxSource, Extension sxType, final XWikiContext context) throws XWikiException {
        if (this.isSourceMapRequest(context)) {
            super.renderExtension(new SxSource(){

                @Override
                public long getLastModifiedDate() {
                    return sxSource.getLastModifiedDate();
                }

                @Override
                public String getContent() {
                    return JsxAction.this.loadSourceMap(context);
                }

                @Override
                public SxSource.CachePolicy getCachePolicy() {
                    return sxSource.getCachePolicy();
                }
            }, new JsExtension(){

                @Override
                public String getContentType() {
                    return "application/json";
                }
            }, context);
        } else {
            super.renderExtension(sxSource, sxType, context);
        }
    }

    @Override
    protected String compress(String source, SxCompressor compressor, XWikiContext context) {
        String sourceMap;
        String output = super.compress(source, compressor, context);
        if (compressor instanceof JsExtension.JsCompressor && (sourceMap = ((JsExtension.JsCompressor)compressor).getSourceMap()) != null) {
            sourceMap = this.fixSourceURL(sourceMap, context);
            context.getResponse().setHeader("X-SourceMap", this.saveSourceMap(sourceMap, context));
        }
        return output;
    }

    private String saveSourceMap(String sourceMap, XWikiContext context) {
        HashMap<String, String> sourceMaps = (HashMap<String, String>)context.getRequest().getSession().getAttribute(SOURCE_MAPS_SESSION_ATTRIBUTE);
        if (sourceMaps == null) {
            sourceMaps = new HashMap<String, String>();
            context.getRequest().getSession().setAttribute(SOURCE_MAPS_SESSION_ATTRIBUTE, sourceMaps);
        }
        String currentURL = context.getURL().toString();
        sourceMaps.put(currentURL, sourceMap);
        return this.extendQueryString(currentURL, SOURCE_MAP_PARAMS);
    }

    private String loadSourceMap(XWikiContext context) {
        Map sourceMaps = (Map)context.getRequest().getSession().getAttribute(SOURCE_MAPS_SESSION_ATTRIBUTE);
        if (sourceMaps != null) {
            String sourceMapKey = context.getURL().toString();
            sourceMapKey = sourceMapKey.replaceFirst("(\\?)sourceMap=true&minify=false(&|$)", "$1");
            sourceMapKey = StringUtils.removeEnd((String)sourceMapKey, (String)"?");
            return sourceMaps.getOrDefault(sourceMapKey, "");
        }
        return "";
    }

    private String extendQueryString(String url, String params) {
        int insertionPoint = url.indexOf(63) + 1;
        if (insertionPoint <= 0) {
            return String.valueOf(url) + '?' + params;
        }
        return String.valueOf(url.substring(0, insertionPoint)) + params + '&' + url.substring(insertionPoint);
    }

    private String fixSourceURL(String sourceMapJSON, XWikiContext context) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode sourceMap = (ObjectNode)objectMapper.readTree(sourceMapJSON);
            ArrayNode sources = (ArrayNode)sourceMap.get("sources");
            sources.set(sources.size() - 1, (JsonNode)sources.textNode(this.getSourceURL(context)));
            return objectMapper.writeValueAsString((Object)sourceMap);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to fix the source path in the generated JavaScript source mapping. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return sourceMapJSON;
        }
    }

    private String getSourceURL(XWikiContext context) {
        XWikiURLFactory urlFactory = context.getURLFactory();
        String sourceURL = this.extendQueryString(urlFactory.getRequestURL(context).toString(), "minify=false");
        try {
            return urlFactory.getURL(new URL(sourceURL), context);
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Failed to convert absolute source URL to relative URL. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return sourceURL;
        }
    }

    private boolean isSourceMapRequest(XWikiContext context) {
        return "true".equals(context.getRequest().getParameter("sourceMap"));
    }
}

