/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.skinx.AbstractSkinExtensionPlugin;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractDocumentSkinExtensionPlugin
extends AbstractSkinExtensionPlugin
implements EventListener {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDocumentSkinExtensionPlugin.class);
    private static final String USE_FIELDNAME = "use";
    private Map<String, Set<DocumentReference>> alwaysUsedExtensions;
    private final List<Event> events = new ArrayList<Event>(3);

    public AbstractDocumentSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.events.add((Event)new DocumentCreatedEvent());
        this.events.add((Event)new DocumentDeletedEvent());
        this.events.add((Event)new DocumentUpdatedEvent());
        this.events.add((Event)new WikiDeletedEvent());
    }

    public List<Event> getEvents() {
        return this.events;
    }

    protected abstract String getExtensionClassName();

    protected abstract String getExtensionName();

    public void init(XWikiContext context) {
        super.init(context);
        this.alwaysUsedExtensions = new HashMap<String, Set<DocumentReference>>();
        this.getExtensionClass(context);
        ((ObservationManager)Utils.getComponent(ObservationManager.class)).addListener((EventListener)this);
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
        this.getExtensionClass(context);
    }

    @Override
    public Set<String> getAlwaysUsedExtensions(XWikiContext context) {
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING);
        Set<DocumentReference> references = this.getAlwaysUsedExtensions();
        HashSet<String> names = new HashSet<String>(references.size());
        for (DocumentReference reference : references) {
            names.add((String)serializer.serialize((EntityReference)reference, new Object[0]));
        }
        return names;
    }

    public Set<DocumentReference> getAlwaysUsedExtensions() {
        XWikiContext context = Utils.getContext();
        String currentWiki = (String)StringUtils.defaultIfEmpty((CharSequence)context.getWikiId(), (CharSequence)context.getMainXWiki());
        if (this.alwaysUsedExtensions.get(currentWiki) != null) {
            return this.alwaysUsedExtensions.get(currentWiki);
        }
        HashSet<DocumentReference> extensions = new HashSet<DocumentReference>();
        String query = ", BaseObject as obj, StringProperty as use where obj.className='" + this.getExtensionClassName() + "'" + " and obj.name=doc.fullName and use.id.id=obj.id and use.id.name='use' and use.value='always'";
        try {
            for (DocumentReference extension : context.getWiki().getStore().searchDocumentReferences(query, context)) {
                try {
                    XWikiDocument doc = context.getWiki().getDocument(extension, context);
                    if (!((AuthorizationManager)Utils.getComponent(AuthorizationManager.class)).hasAccess(Right.PROGRAM, doc.getContentAuthorReference(), (EntityReference)doc.getDocumentReference())) continue;
                    extensions.add(extension);
                }
                catch (XWikiException e1) {
                    LOGGER.error("Error while adding skin extension [{}] as always used. It will be ignored.", (Object)extension, (Object)e1);
                }
            }
            this.alwaysUsedExtensions.put(currentWiki, extensions);
            return extensions;
        }
        catch (XWikiException e) {
            LOGGER.error("Error while retrieving always used JS extensions", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public boolean hasPageExtensions(XWikiContext context) {
        XWikiDocument doc = context.getDoc();
        Vector objects = doc.getObjects(this.getExtensionClassName());
        if (objects != null) {
            for (BaseObject obj : objects) {
                if (obj == null || !obj.getStringValue(USE_FIELDNAME).equals("currentPage")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void use(String resource, XWikiContext context) {
        String canonicalResource = this.getCanonicalDocumentName(resource);
        LOGGER.debug("Using [{}] as [{}] extension", (Object)canonicalResource, (Object)this.getName());
        this.getPulledResources(context).add(canonicalResource);
        this.getParametersMap(context).remove(canonicalResource);
    }

    @Override
    public void use(String resource, Map<String, Object> parameters, XWikiContext context) {
        String canonicalResource = this.getCanonicalDocumentName(resource);
        this.getPulledResources(context).add(canonicalResource);
        this.getParametersMap(context).put(canonicalResource, parameters);
    }

    @Override
    public String endParsing(String content, XWikiContext context) {
        return super.endParsing(content, context);
    }

    private boolean setExtensionClassDocumentFields(XWikiDocument doc) {
        boolean needsUpdate = false;
        if (StringUtils.isBlank((CharSequence)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((CharSequence)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(doc.getCreator());
        }
        if (StringUtils.isBlank((CharSequence)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((CharSequence)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle("XWiki " + this.getExtensionName() + " Extension Class");
        }
        if (StringUtils.isBlank((CharSequence)doc.getContent()) || !Syntax.XWIKI_2_0.equals((Object)doc.getSyntax())) {
            doc.setContent("{{include document=\"XWiki.ClassSheet\" /}}");
            doc.setSyntax(Syntax.XWIKI_2_0);
        }
        if (!doc.isHidden().booleanValue()) {
            needsUpdate = true;
            doc.setHidden(Boolean.valueOf(true));
        }
        return needsUpdate;
    }

    public BaseClass getExtensionClass(XWikiContext context) {
        try {
            XWikiDocument doc = context.getWiki().getDocument(this.getExtensionClassName(), context);
            boolean needsUpdate = false;
            BaseClass bclass = doc.getXClass();
            if (context.get((Object)"initdone") != null) {
                return bclass;
            }
            bclass.setName(this.getExtensionClassName());
            needsUpdate |= bclass.addTextField("name", "Name", 30);
            needsUpdate |= bclass.addTextAreaField("code", "Code", 50, 20);
            needsUpdate |= bclass.addStaticListField(USE_FIELDNAME, "Use this extension", "currentPage|onDemand|always");
            needsUpdate |= bclass.addBooleanField("parse", "Parse content", "yesno");
            needsUpdate |= bclass.addStaticListField("cache", "Caching policy", "long|short|default|forbid");
            if (needsUpdate |= this.setExtensionClassDocumentFields(doc)) {
                context.getWiki().saveDocument(doc, context);
            }
            return bclass;
        }
        catch (Exception ex) {
            LOGGER.error("Cannot initialize skin extension class [{}]", (Object)this.getExtensionClassName(), (Object)ex);
            return null;
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            this.alwaysUsedExtensions.remove(((WikiDeletedEvent)event).getWikiId());
        } else {
            this.onDocumentEvent((XWikiDocument)source, (XWikiContext)data);
        }
    }

    private void onDocumentEvent(XWikiDocument document, XWikiContext context) {
        boolean remove = false;
        if (document.getObject(this.getExtensionClassName()) != null) {
            if (document.getObject(this.getExtensionClassName(), USE_FIELDNAME, "always", false) != null) {
                if (((AuthorizationManager)Utils.getComponent(AuthorizationManager.class)).hasAccess(Right.PROGRAM, document.getContentAuthorReference(), (EntityReference)document.getDocumentReference())) {
                    this.getAlwaysUsedExtensions().add(document.getDocumentReference());
                    return;
                }
                remove = true;
            } else {
                remove = true;
            }
        } else if (document.getOriginalDocument().getObject(this.getExtensionClassName()) != null) {
            remove = true;
        }
        if (remove) {
            this.getAlwaysUsedExtensions().remove(document.getDocumentReference());
        }
    }

    private String getCanonicalDocumentName(String documentName) {
        EntityReferenceResolver resolver = (EntityReferenceResolver)Utils.getComponent((Type)EntityReferenceResolver.TYPE_STRING, (String)"current");
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING);
        return (String)serializer.serialize(resolver.resolve((Object)documentName, EntityType.DOCUMENT, new Object[0]), new Object[0]);
    }
}

