/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.svg.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.svg.SVGRasterizer;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.resource.temporary.TemporaryResourceStore;

@Component
@Singleton
public class BatikSVGRasterizer
implements SVGRasterizer {
    private static final String TEMP_DIR_NAME = "svg";
    private static final String RASTER_FILE_EXTENSION = ".png";
    @Inject
    private Logger logger;
    @Inject
    private TemporaryResourceStore temporaryResourceStore;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentResolver;
    @Inject
    private Container container;

    @Override
    public File rasterizeToTemporaryFile(String content, int width, int height) throws IOException {
        String fileName = this.getTemporaryFileName(content, width, height);
        TemporaryResourceReference reference = new TemporaryResourceReference(TEMP_DIR_NAME, fileName, null);
        File out = this.temporaryResourceStore.getTemporaryFile(reference);
        if (this.rasterizeToFile(content, out, width, height)) {
            return out;
        }
        return null;
    }

    @Override
    public TemporaryResourceReference rasterizeToTemporaryResource(String content, int width, int height) throws IOException {
        return this.rasterizeToTemporaryResource(content, width, height, this.getCurrentDocument());
    }

    @Override
    public TemporaryResourceReference rasterizeToTemporaryResource(String content, int width, int height, DocumentReference targetContext) throws IOException {
        String fileName = this.getTemporaryFileName(content, width, height);
        TemporaryResourceReference reference = new TemporaryResourceReference(TEMP_DIR_NAME, fileName, (EntityReference)targetContext);
        File out = this.temporaryResourceStore.getTemporaryFile(reference);
        if (this.rasterizeToFile(content, out, width, height)) {
            return reference;
        }
        return null;
    }

    @Override
    public void rasterizeToResponse(String content, int width, int height) throws IOException {
        if (!(this.container.getResponse() instanceof ServletResponse)) {
            return;
        }
        HttpServletResponse response = ((ServletResponse)this.container.getResponse()).getHttpServletResponse();
        File result = this.rasterizeToTemporaryFile(content, width, height);
        if (result == null) {
            return;
        }
        response.setContentLength((int)result.length());
        response.setContentType("image/png");
        ServletOutputStream os = response.getOutputStream();
        FileUtils.copyFile((File)result, (OutputStream)os);
        os.flush();
    }

    private boolean rasterizeToFile(String content, File out, int width, int height) throws IOException {
        if (!out.getParentFile().exists() && !out.getParentFile().mkdirs()) {
            this.logger.debug("Failed to create temporary folder [{}].", (Object)out.getParentFile().getAbsolutePath());
            return false;
        }
        if (out.exists() && out.isFile()) {
            this.logger.debug("Reusing existing temporary raster image: {}", (Object)out.getAbsolutePath());
            return true;
        }
        try (FileOutputStream fout = new FileOutputStream(out);){
            this.logger.debug("Rasterizing to temp file: {}", (Object)out.getAbsolutePath());
            TranscoderInput input = new TranscoderInput((Reader)new StringReader(content));
            TranscoderOutput output = new TranscoderOutput((OutputStream)fout);
            boolean success = this.rasterize(input, output, width, height);
            if (!success) {
                out.delete();
            }
            boolean bl = success;
            return bl;
        }
    }

    private boolean rasterize(TranscoderInput input, TranscoderOutput output, int width, int height) {
        PNGTranscoder transcoder = new PNGTranscoder();
        if (width > 0) {
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
        }
        if (height > 0) {
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
        }
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, (Object)Float.valueOf(8192.0f));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, (Object)Float.valueOf(8192.0f));
        try {
            transcoder.transcode(input, output);
            return true;
        }
        catch (TranscoderException ex) {
            this.logger.warn("Failed to rasterize SVG image: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            return false;
        }
    }

    private String getTemporaryFileName(String content, int width, int height) {
        return Math.abs(content.hashCode()) + RASTER_FILE_EXTENSION;
    }

    private DocumentReference getCurrentDocument() {
        return this.currentDocumentResolver.resolve((Object)"", new Object[0]);
    }
}

