/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.svg.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.platform.svg.SVGRasterizer;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.temporary.TemporaryResourceReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.url.ExtendedURL;

@Component
@Named(value="svg")
@Singleton
public class SVGScriptService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    private SVGRasterizer component;
    @Inject
    @Named(value="standard/tmp")
    private ResourceReferenceSerializer<TemporaryResourceReference, ExtendedURL> serializer;

    public ExtendedURL rasterizeToTemporaryResource(String content) {
        return this.rasterizeToTemporaryResource(content, 0, 0);
    }

    public ExtendedURL rasterizeToTemporaryResource(String content, int width, int height) {
        try {
            return (ExtendedURL)this.serializer.serialize((ResourceReference)this.component.rasterizeToTemporaryResource(content, width, height));
        }
        catch (Exception ex) {
            this.logger.warn("Failed to rasterize SVG image to temporary resource: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            return null;
        }
    }

    public ExtendedURL rasterizeToTemporaryResource(String content, DocumentReference targetContext) {
        return this.rasterizeToTemporaryResource(content, 0, 0, targetContext);
    }

    public ExtendedURL rasterizeToTemporaryResource(String content, int width, int height, DocumentReference targetContext) {
        try {
            ExtendedURL result = (ExtendedURL)this.serializer.serialize((ResourceReference)this.component.rasterizeToTemporaryResource(content, width, height, targetContext));
            return result;
        }
        catch (Exception ex) {
            this.logger.warn("Failed to rasterize SVG image to temporary resource in context [{}]: {}", (Object)targetContext, (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            return null;
        }
    }

    public boolean rasterizeToResponse(String content) {
        return this.rasterizeToResponse(content, 0, 0);
    }

    public boolean rasterizeToResponse(String content, int width, int height) {
        try {
            this.component.rasterizeToResponse(content, width, height);
            return true;
        }
        catch (Exception ex) {
            this.logger.warn("Failed to rasterize SVG image to response: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            return false;
        }
    }
}

