/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui;

import org.openqa.selenium.WebDriver;
import org.xwiki.test.integration.XWikiExecutor;
import org.xwiki.test.ui.TestUtils;
import org.xwiki.test.ui.WebDriverFactory;
import org.xwiki.test.ui.XWikiWrappingDriver;

public class PersistentTestContext {
    private final XWikiExecutor executor;
    private final XWikiWrappingDriver driver;
    private String currentTestName;
    private final TestUtils util = new TestUtils();
    private WebDriverFactory webDriverFactory = new WebDriverFactory();
    private static final String BROWSER_NAME_SYSTEM_PROPERTY = System.getProperty("browser", "*firefox");

    public PersistentTestContext() throws Exception {
        this(new XWikiExecutor(0));
        this.executor.start();
    }

    public PersistentTestContext(XWikiExecutor executor) throws Exception {
        this.executor = executor;
        WebDriver nativeDriver = this.webDriverFactory.createWebDriver(BROWSER_NAME_SYSTEM_PROPERTY);
        this.driver = new XWikiWrappingDriver(nativeDriver, this.getUtil());
        this.getUtil().setDriverImplicitWait(this.driver);
    }

    public PersistentTestContext(PersistentTestContext toClone) {
        this.executor = toClone.executor;
        this.driver = toClone.driver;
    }

    public void setCurrentTestName(String currentTestName) {
        this.currentTestName = currentTestName;
    }

    public String getCurrentTestName() {
        return this.currentTestName;
    }

    public XWikiWrappingDriver getDriver() {
        return this.driver;
    }

    public TestUtils getUtil() {
        return this.util;
    }

    public void shutdown() throws Exception {
        this.driver.close();
        this.executor.stop();
    }

    public PersistentTestContext getUnstoppable() {
        return new PersistentTestContext(this){

            @Override
            public void shutdown() {
            }
        };
    }
}

