/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.InlinePage;
import org.xwiki.test.ui.po.editor.ClassEditPage;
import org.xwiki.test.ui.po.editor.ObjectEditPage;
import org.xwiki.test.ui.po.editor.RightsEditPage;
import org.xwiki.test.ui.po.editor.WYSIWYGEditPage;
import org.xwiki.test.ui.po.editor.WikiEditPage;

public class BasePage
extends BaseElement {
    @FindBy(id="xwikimaincontainer")
    private WebElement mainContainerDiv;

    public String getPageTitle() {
        return this.getDriver().getTitle();
    }

    public String getPageURL() {
        return this.getDriver().getCurrentUrl();
    }

    public String getMetaDataValue(String metaName) {
        return this.getDriver().findElement(By.xpath((String)("//meta[@name='" + metaName + "']"))).getAttribute("content");
    }

    public boolean isAuthenticated() {
        return !BasePage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.id((String)"tmUser")).isEmpty();
    }

    public boolean isNewDocument() {
        return (Boolean)this.getDriver().executeScript("return XWiki.docisnew", new Object[0]);
    }

    protected void hoverOverMenu(String menuId) {
        this.waitUntilElementIsVisible(By.id((String)menuId));
        WebElement menuDiv = this.getDriver().findElement(By.id((String)menuId));
        this.getDriver().executeScript("showsubmenu(arguments[0])", menuDiv);
        this.waitUntilElementIsVisible(By.xpath((String)("//div[@id = '" + menuId + "']//span[contains(@class, 'submenu')]")));
    }

    protected void clickContentMenuTopEntry(String id) {
        this.sendKeys(new CharSequence[]{Keys.HOME});
        this.getDriver().findElement(By.xpath((String)("//div[@id='" + id + "']//strong"))).click();
    }

    protected void clickContentMenuEditSubMenuEntry(String id) {
        this.hoverOverMenu("tmEdit");
        this.getDriver().findElement(By.xpath((String)("//a[@id='" + id + "']"))).click();
    }

    public void edit() {
        this.clickContentMenuTopEntry("tmEdit");
    }

    public String getEditURL() {
        return this.getDriver().findElement(By.xpath((String)"//div[@id='tmEdit']//a")).getAttribute("href");
    }

    public WikiEditPage editWiki() {
        this.clickContentMenuEditSubMenuEntry("tmEditWiki");
        return new WikiEditPage();
    }

    public WYSIWYGEditPage editWYSIWYG() {
        this.clickContentMenuEditSubMenuEntry("tmEditWysiwyg");
        return new WYSIWYGEditPage();
    }

    public <T extends InlinePage> T editInline() {
        this.clickContentMenuEditSubMenuEntry("tmEditInline");
        return this.createInlinePage();
    }

    protected <T extends InlinePage> T createInlinePage() {
        return (T)new InlinePage();
    }

    public RightsEditPage editRights() {
        this.clickContentMenuEditSubMenuEntry("tmEditRights");
        return new RightsEditPage();
    }

    public ObjectEditPage editObjects() {
        this.clickContentMenuEditSubMenuEntry("tmEditObject");
        return new ObjectEditPage();
    }

    public ClassEditPage editClass() {
        this.clickContentMenuEditSubMenuEntry("tmEditClass");
        return new ClassEditPage();
    }

    public void sendKeys(CharSequence ... keys) {
        this.mainContainerDiv.sendKeys(keys);
    }

    public void waitUntilPageIsLoaded() {
        this.waitUntilElementIsVisible(By.id((String)"footerglobal"));
    }
}

