/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.ComparePage;
import org.xwiki.test.ui.po.ViewPage;

public class HistoryPane
extends BaseElement {
    @FindBy(id="historycontent")
    private WebElement pane;

    public boolean hasVersionWithSummary(String summary) {
        By commentVersionXPath;
        List tableEntries = this.pane.findElements(By.xpath((String)".//table/tbody/tr"));
        try {
            this.pane.findElement(By.xpath((String)".//tr[2]/td/input"));
            commentVersionXPath = By.xpath((String)".//td[6]");
        }
        catch (NoSuchElementException e) {
            commentVersionXPath = By.xpath((String)".//td[4]");
        }
        for (WebElement tableEntry : tableEntries) {
            try {
                WebElement cell = tableEntry.findElement(commentVersionXPath);
                if (!cell.getText().trim().contentEquals(summary)) continue;
                return true;
            }
            catch (NoSuchElementException e) {
            }
        }
        return false;
    }

    public String getCurrentVersion() {
        try {
            this.pane.findElement(By.xpath((String)".//tr[2]/td/input"));
            return this.pane.findElement(By.xpath((String)".//*[contains(@class, 'currentversion')]/td[3]/a")).getText();
        }
        catch (NoSuchElementException e) {
            return this.pane.findElement(By.xpath((String)".//*[contains(@class, 'currentversion')]/td[1]/a")).getText();
        }
    }

    public String getCurrentVersionComment() {
        try {
            this.pane.findElement(By.xpath((String)".//tr[2]/td/input"));
            return this.pane.findElement(By.xpath((String)".//*[contains(@class, 'currentversion')]/td[6]")).getText();
        }
        catch (NoSuchElementException e) {
            return this.pane.findElement(By.xpath((String)".//*[contains(@class, 'currentversion')]/td[4]")).getText();
        }
    }

    public String getCurrentAuthor() {
        try {
            this.pane.findElement(By.xpath((String)".//tr[2]/td/input"));
            return this.pane.findElement(By.xpath((String)".//*[contains(@class, 'currentversion')]/td[4]")).getText();
        }
        catch (NoSuchElementException e) {
            return this.pane.findElement(By.xpath((String)".//*[contains(@class, 'currentversion')]/td[2]")).getText();
        }
    }

    public ViewPage rollbackToVersion(String version) {
        this.makeConfirmDialogSilent(true);
        this.pane.findElement(By.xpath((String)(".//table[@class='xwikidatatable']//tr[contains(., '" + version + "')]//td[@class='xwikibuttonlink']/a[contains(.,'Rollback')]"))).click();
        return new ViewPage();
    }

    public void deleteVersion(String version) {
        this.makeConfirmDialogSilent(true);
        this.pane.findElement(By.xpath((String)(".//table[@class='xwikidatatable']//tr[contains(., '" + version + "')]//td[@class='xwikibuttonlink']/a[contains(.,'Delete')]"))).click();
    }

    public HistoryPane showMinorEdits() {
        HistoryPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.pane, By.name((String)"viewminorversions")).click();
        return new HistoryPane();
    }

    public ComparePage compare(String fromVersion, String toVersion) {
        String versionXPath = ".//input[@name = 'rev%s' and @value = '%s']";
        HistoryPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.pane, By.xpath((String)String.format(versionXPath, 1, fromVersion))).click();
        HistoryPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.pane, By.xpath((String)String.format(versionXPath, 2, toVersion))).click();
        HistoryPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.pane, By.xpath((String)".//input[@accesskey = 'c']")).click();
        return new ComparePage();
    }
}

