/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.List;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.xwiki.test.ui.po.AttachmentsPane;
import org.xwiki.test.ui.po.BasePage;
import org.xwiki.test.ui.po.CommentsTab;
import org.xwiki.test.ui.po.ConfirmationPage;
import org.xwiki.test.ui.po.CopyPage;
import org.xwiki.test.ui.po.CreatePagePage;
import org.xwiki.test.ui.po.CreateSpacePage;
import org.xwiki.test.ui.po.HistoryPane;
import org.xwiki.test.ui.po.LoginPage;
import org.xwiki.test.ui.po.RegistrationPage;
import org.xwiki.test.ui.po.editor.WYSIWYGEditPage;

public class ViewPage
extends BasePage {
    @FindBys(value={@FindBy(id="tmRegister"), @FindBy(tagName="a")})
    private WebElement registerLink;
    @FindBys(value={@FindBy(id="tmLogin"), @FindBy(tagName="a")})
    private WebElement loginLink;
    @FindBys(value={@FindBy(id="tmLogout"), @FindBy(tagName="a")})
    private WebElement logoutLink;
    @FindBys(value={@FindBy(id="tmUser"), @FindBy(tagName="a")})
    private WebElement userLink;
    @FindBy(id="tmCreatePage")
    private WebElement createPageMenuLink;
    @FindBy(id="tmCreateSpace")
    private WebElement createSpaceMenuLink;
    @FindBy(id="xwikicontent")
    private WebElement content;
    @FindBy(id="tmActionCopy")
    private WebElement copyPageLink;
    @FindBy(id="tmActionDelete")
    private WebElement deletePageLink;
    @FindBy(id="document-title")
    private WebElement documentTitle;
    @FindBy(id="hierarchy")
    private WebElement breadcrumbDiv;
    @FindBy(id="tmWatchSpace")
    private WebElement watchSpaceLink;
    @FindBy(id="tmWatchDocument")
    private WebElement watchDocumentLink;

    public boolean hasLoginLink() {
        return !ViewPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.id((String)"tmLogin")).isEmpty();
    }

    public LoginPage login() {
        this.loginLink.click();
        return new LoginPage();
    }

    public String getCurrentUser() {
        return this.userLink.getText();
    }

    public void logout() {
        this.logoutLink.click();
    }

    public RegistrationPage register() {
        this.registerLink.click();
        return new RegistrationPage();
    }

    public CreatePagePage createPage() {
        this.hoverOverMenu("tmCreate");
        this.createPageMenuLink.click();
        return new CreatePagePage();
    }

    public CreateSpacePage createSpace() {
        this.hoverOverMenu("tmCreate");
        this.createSpaceMenuLink.click();
        return new CreateSpacePage();
    }

    public CommentsTab openCommentsDocExtraPane() {
        this.getDriver().findElement(By.id((String)"Commentslink")).click();
        this.waitUntilElementIsVisible(By.id((String)"commentscontent"));
        return new CommentsTab();
    }

    public HistoryPane openHistoryDocExtraPane() {
        this.getDriver().findElement(By.id((String)"Historylink")).click();
        this.waitUntilElementIsVisible(By.id((String)"historycontent"));
        return new HistoryPane();
    }

    public AttachmentsPane openAttachmentsDocExtraPane() {
        this.getDriver().findElement(By.id((String)"Attachmentslink")).click();
        this.waitUntilElementIsVisible(By.id((String)"attachmentscontent"));
        return new AttachmentsPane();
    }

    public boolean exists() {
        List<WebElement> messages = ViewPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.className((String)"xwikimessage"));
        for (WebElement message : messages) {
            if (!message.getText().contains("The requested document could not be found.") && !message.getText().contains("The document has been deleted.")) continue;
            return false;
        }
        return true;
    }

    public String getContent() {
        return this.content.getText();
    }

    public WYSIWYGEditPage editSection(int sectionNumber) {
        By sectionBy = By.xpath((String)("//span[contains(@class, 'edit_section')][" + sectionNumber + "]/a"));
        this.waitUntilElementIsVisible(sectionBy);
        this.getDriver().findElement(sectionBy).click();
        return new WYSIWYGEditPage();
    }

    public void clickWantedLink(String spaceName, String pageName, boolean waitForTemplateDisplay) {
        WebElement brokenLink = this.getDriver().findElement(By.xpath((String)("//span[@class='wikicreatelink']/a[contains(@href,'/create/" + spaceName + "/" + pageName + "')]")));
        brokenLink.click();
        if (waitForTemplateDisplay) {
            this.waitUntilElementIsVisible(By.xpath((String)"//div[@class='modal-popup']//input[@type='submit']"));
        }
    }

    public CopyPage copy() {
        this.hoverOverMenu("tmPage");
        this.copyPageLink.click();
        return new CopyPage();
    }

    public ConfirmationPage delete() {
        this.hoverOverMenu("tmPage");
        this.deletePageLink.click();
        return new ConfirmationPage();
    }

    public boolean canDelete() {
        if (ViewPage.getUtil().hasElement(By.xpath((String)"//div[@id='tmPage']//span[@class='menuarrow']"))) {
            this.hoverOverMenu("tmPage");
            return ViewPage.getUtil().hasElement(By.id((String)"tmActionDelete"));
        }
        return false;
    }

    public String getDocumentTitle() {
        return this.documentTitle.getText();
    }

    public String getBreadcrumbContent() {
        return this.breadcrumbDiv.getText();
    }

    public boolean hasBreadcrumbContent(String breadcrumbItem, boolean isCurrent) {
        List<WebElement> result = isCurrent ? ViewPage.getUtil().findElementsWithoutWaiting(this.getDriver(), this.breadcrumbDiv, By.xpath((String)("span[@class = 'current' and text() ='" + breadcrumbItem + "']"))) : ViewPage.getUtil().findElementsWithoutWaiting(this.getDriver(), this.breadcrumbDiv, By.xpath((String)("a[text() = '" + breadcrumbItem + "']")));
        return result.size() > 0;
    }

    public ViewPage clickBreadcrumbLink(String linkText) {
        this.breadcrumbDiv.findElement(By.linkText((String)linkText)).click();
        return new ViewPage();
    }

    public boolean isInlinePage() {
        return this.getDriver().findElements(By.xpath((String)"//form[@id = 'inline']")).size() > 0;
    }

    public void waitForDocExtraPaneActive(String paneId) {
        this.waitUntilElementIsVisible(By.id((String)(paneId + "content")));
    }

    public void watchDocument() {
        this.hoverOverMenu("tmPage");
        this.watchDocumentLink.click();
    }

    public void watchSpace() {
        this.hoverOverMenu("tmSpace");
        this.watchSpaceLink.click();
    }

    public void waitUntilContent(final String expectedValue) {
        ViewPage.getUtil().waitUntilCondition(new ExpectedCondition<Boolean>(){
            private Pattern pattern;
            {
                this.pattern = Pattern.compile(expectedValue, 32);
            }

            public Boolean apply(WebDriver driver) {
                driver.navigate().refresh();
                return this.pattern.matcher(ViewPage.this.getContent()).matches();
            }
        });
    }
}

