/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po.editor.wysiwyg;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.BaseElement;

public class RichTextAreaElement
extends BaseElement {
    private final WebElement iframe;

    public RichTextAreaElement(WebElement iframe) {
        this.iframe = iframe;
    }

    public String getText() {
        String windowHandle = this.getDriver().getWindowHandle();
        this.getDriver().switchTo().frame(this.iframe);
        String content = this.getDriver().findElement(By.id((String)"body")).getText();
        this.getDriver().switchTo().window(windowHandle);
        return content;
    }

    public void clear() {
        String windowHandle = this.getDriver().getWindowHandle();
        this.getDriver().switchTo().frame(this.iframe);
        this.executeJavascript("document.body.innerHTML = ''", new Object[0]);
        this.getDriver().switchTo().window(windowHandle);
    }

    public void sendKeys(CharSequence ... keysToSend) {
        if (keysToSend.length == 0) {
            return;
        }
        String windowHandle = this.getDriver().getWindowHandle();
        this.getDriver().switchTo().frame(this.iframe);
        StringBuilder script = new StringBuilder();
        script.append("window.__savedRange = window.getSelection().getRangeAt(0);\n");
        script.append("document.body.contentEditable = false;\n");
        script.append("var div = document.createElement('div');\n");
        script.append("div.style.minHeight = '20px';");
        script.append("document.body.appendChild(div);\n");
        script.append("var contentRange = document.createRange();\n");
        script.append("contentRange.setStartBefore(document.body.firstChild);\n");
        script.append("contentRange.setEndBefore(div);\n");
        script.append("div.appendChild(contentRange.extractContents());\n");
        script.append("div.contentEditable = true;\n");
        script.append("window.getSelection().removeAllRanges();\n");
        script.append("window.getSelection().addRange(window.__savedRange);\n");
        script.append("window.__savedRange = undefined;\n");
        this.executeJavascript(script.toString(), new Object[0]);
        this.getDriver().findElement(By.xpath((String)"//body/div")).sendKeys(keysToSend);
        script.delete(0, script.length());
        script.append("window.__savedRange = window.getSelection().getRangeAt(0);\n");
        script.append("var contentRange = document.createRange();\n");
        script.append("contentRange.selectNodeContents(document.body.firstChild);\n");
        script.append("document.body.appendChild(contentRange.extractContents());\n");
        script.append("document.body.removeChild(document.body.firstChild);\n");
        script.append("document.body.contentEditable = true;\n");
        script.append("window.getSelection().removeAllRanges();\n");
        script.append("window.getSelection().addRange(window.__savedRange);\n");
        script.append("window.__savedRange = undefined;\n");
        this.executeJavascript(script.toString(), new Object[0]);
        this.getDriver().switchTo().window(windowHandle);
    }
}

