/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.SystemUtils;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.test.integration.AntBuildListener;

public class XWikiExecutor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XWikiExecutor.class);
    public static final String SKIP_STARTING_XWIKI_INSTANCE = System.getProperty("xwiki.test.skipStart", "false");
    public static final String BASEDIR = System.getProperty("basedir");
    public static final String URL = System.getProperty("xwiki.test.baseURL", "http://localhost");
    public static final String DEFAULT_PORT = System.getProperty("xwikiPort", "8080");
    public static final String DEFAULT_STOPPORT = System.getProperty("xwikiStopPort", "8079");
    public static final String DEFAULT_RMIPORT = System.getProperty("rmiPort", "9010");
    private static final String DEFAULT_EXECUTION_DIRECTORY = System.getProperty("xwikiExecutionDirectory");
    private static final String START_COMMAND = System.getProperty("xwikiExecutionStartCommand");
    private static final String STOP_COMMAND = System.getProperty("xwikiExecutionStopCommand");
    private static final boolean DEBUG = System.getProperty("debug", "false").equalsIgnoreCase("true");
    private static final String WEBINF_PATH = "/webapps/xwiki/WEB-INF";
    private static final String XWIKICFG_PATH = "/webapps/xwiki/WEB-INF/xwiki.cfg";
    private static final String XWIKIPROPERTIES_PATH = "/webapps/xwiki/WEB-INF/xwiki.properties";
    private static final int TIMEOUT_SECONDS = 120;
    private Project project;
    private int port;
    private int stopPort;
    private int rmiPort;
    private String executionDirectory;
    private List<Environment.Variable> env = new ArrayList<Environment.Variable>();
    private String opts;
    private boolean wasStarted;

    public XWikiExecutor(int index) {
        this.project = new Project();
        this.project.init();
        this.project.addBuildListener((BuildListener)new AntBuildListener(DEBUG));
        String portString = System.getProperty("xwikiPort" + index);
        this.port = portString != null ? Integer.valueOf(portString) : Integer.valueOf(DEFAULT_PORT) + index;
        String stopPortString = System.getProperty("xwikiStopPort" + index);
        this.stopPort = stopPortString != null ? Integer.valueOf(stopPortString) : Integer.valueOf(DEFAULT_STOPPORT) - index;
        String rmiPortString = System.getProperty("rmiPort" + index);
        this.rmiPort = rmiPortString != null ? Integer.valueOf(rmiPortString) : Integer.valueOf(DEFAULT_RMIPORT) + index;
        this.executionDirectory = System.getProperty("xwikiExecutionDirectory" + index);
        if (this.executionDirectory == null) {
            this.executionDirectory = DEFAULT_EXECUTION_DIRECTORY;
            if (this.executionDirectory == null) {
                this.executionDirectory = BASEDIR + "/target/xwiki";
            }
            if (index > 0) {
                this.executionDirectory = this.executionDirectory + "-" + index;
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public String getExecutionDirectory() {
        if (this.executionDirectory == null) {
            throw new RuntimeException("Invalid configuration for the execution directory. The [xwikiExecutionDirectory] system property must be specified.");
        }
        return this.executionDirectory;
    }

    public void addEnvironmentVariable(String key, String value) {
        Environment.Variable variable = new Environment.Variable();
        variable.setKey(key);
        variable.setValue(value);
        this.env.add(variable);
    }

    public void setOpts(String opts) {
        this.opts = opts;
    }

    public void start() throws Exception {
        if (SKIP_STARTING_XWIKI_INSTANCE.equals("true")) {
            System.out.println(String.format("Using running instance at [%s:%s]", URL, this.getPort()));
        } else {
            System.out.println(String.format("Starting XWiki server at [%s:%s]", URL, this.getPort()));
            boolean bl = this.wasStarted = !this.isXWikiStarted((String)this.getURL(), (int)15).timedOut;
            if (!this.wasStarted) {
                this.startXWikiInSeparateThread();
                this.waitForXWikiToLoad();
            } else {
                System.out.println("XWiki server is already started!");
            }
        }
    }

    private void startXWikiInSeparateThread() {
        Thread startThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    XWikiExecutor.this.startXWiki();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        startThread.start();
    }

    private void startXWiki() throws Exception {
        ExecTask execTask;
        File dir = new File(this.getExecutionDirectory());
        if (dir.exists()) {
            execTask = (ExecTask)this.project.createTask("exec");
            execTask.setDir(new File(this.getExecutionDirectory()));
            for (Environment.Variable variable : this.env) {
                execTask.addEnv(variable);
            }
            if (this.opts != null) {
                Environment.Variable optsVariable = new Environment.Variable();
                optsVariable.setKey("XWIKI_OPTS");
                optsVariable.setValue(this.opts);
                execTask.addEnv(optsVariable);
            }
        } else {
            throw new Exception("Invalid directory from where to start XWiki [" + this.executionDirectory + "]");
        }
        String startCommand = this.getDefaultStartCommand(this.getPort(), this.getStopPort(), this.getRMIPort());
        Commandline commandLine = new Commandline(startCommand);
        execTask.setCommand(commandLine);
        execTask.execute();
    }

    private Task createStopTask() throws Exception {
        File dir = new File(this.getExecutionDirectory());
        if (!dir.exists()) {
            throw new Exception("Invalid directory from where to stop XWiki [" + this.executionDirectory + "]");
        }
        ExecTask execTask = (ExecTask)this.project.createTask("exec");
        execTask.setDir(new File(this.getExecutionDirectory()));
        String stopCommand = this.getDefaultStopCommand(this.getStopPort());
        Commandline commandLine = new Commandline(stopCommand);
        execTask.setCommand(commandLine);
        return execTask;
    }

    private void waitForXWikiToLoad() throws Exception {
        System.out.println("Checking that XWiki is up and running...");
        Response response = this.isXWikiStarted(this.getURL(), 120);
        if (response.timedOut) {
            String message = "Failed to start XWiki in [120] seconds, last error code [" + response.responseCode + ", message [" + new String(response.responseBody) + "]";
            System.out.println(message);
            this.stop();
            throw new RuntimeException(message);
        }
        System.out.println("Server is answering to [" + this.getURL() + "]... cool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response isXWikiStarted(String url, int timeout) throws Exception {
        HttpClient client = new HttpClient();
        boolean connected = false;
        long startTime = System.currentTimeMillis();
        Response response = new Response();
        response.timedOut = false;
        response.responseCode = -1;
        response.responseBody = new byte[0];
        while (!connected && !response.timedOut) {
            GetMethod method = new GetMethod(url);
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
            method.getParams().setParameter("http.socket.timeout", (Object)new Integer(10000));
            try {
                response.responseCode = client.executeMethod((HttpMethod)method);
                response.responseBody = method.getResponseBody();
                if (DEBUG) {
                    System.out.println(String.format("Result of pinging [%s] = [%s], Message = [%s]", url, response.responseCode, new String(response.responseBody)));
                }
                connected = response.responseCode < 400 || response.responseCode == 401;
            }
            catch (Exception e) {
            }
            finally {
                method.releaseConnection();
            }
            Thread.sleep(500L);
            response.timedOut = System.currentTimeMillis() - startTime > (long)timeout * 1000L;
        }
        return response;
    }

    public void stop() throws Exception {
        if (!this.wasStarted) {
            this.createStopTask().execute();
        }
        System.out.println("XWiki server stopped");
    }

    public String getWebInfDirectory() {
        return this.getExecutionDirectory() + WEBINF_PATH;
    }

    public String getXWikiCfgPath() {
        return this.getExecutionDirectory() + XWIKICFG_PATH;
    }

    public String getXWikiPropertiesPath() {
        return this.getExecutionDirectory() + XWIKIPROPERTIES_PATH;
    }

    public Properties loadXWikiCfg() throws Exception {
        return this.getProperties(this.getXWikiCfgPath());
    }

    public Properties loadXWikiProperties() throws Exception {
        return this.getProperties(this.getXWikiPropertiesPath());
    }

    public PropertiesConfiguration loadXWikiPropertiesConfiguration() throws Exception {
        return this.getPropertiesConfiguration(this.getXWikiPropertiesPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private Properties getProperties(String path) throws Exception {
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(path);
            try {
                properties.load(fis);
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Failed to load properties [" + path + "]", (Throwable)e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesConfiguration getPropertiesConfiguration(String path) throws Exception {
        PropertiesConfiguration properties = new PropertiesConfiguration();
        try {
            FileInputStream fis = new FileInputStream(path);
            try {
                properties.load((InputStream)fis);
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Failed to load properties [" + path + "]", (Throwable)e);
        }
        return properties;
    }

    public void saveXWikiCfg(Properties properties) throws Exception {
        this.saveProperties(this.getXWikiCfgPath(), properties);
    }

    @Deprecated
    public void saveXWikiProperties(Properties properties) throws Exception {
        this.saveProperties(this.getXWikiPropertiesPath(), properties);
    }

    public void saveXWikiProperties(PropertiesConfiguration properties) throws Exception {
        this.savePropertiesConfiguration(this.getXWikiPropertiesPath(), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties(String path, Properties properties) throws Exception {
        FileOutputStream fos = new FileOutputStream(path);
        try {
            properties.store(fos, null);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePropertiesConfiguration(String path, PropertiesConfiguration properties) throws Exception {
        FileOutputStream fos = new FileOutputStream(path);
        try {
            properties.save((OutputStream)fos);
        }
        finally {
            fos.close();
        }
    }

    private String getURL() {
        return URL + ":" + this.getPort() + "/xwiki/bin/view/Main?xpage=plain";
    }

    private String getDefaultStartCommand(int port, int stopPort, int rmiPort) {
        String startCommand = START_COMMAND;
        if (startCommand == null) {
            startCommand = SystemUtils.IS_OS_WINDOWS ? String.format("cmd /c start_xwiki.bat %s %s", port, stopPort) : String.format("sh -f start_xwiki.sh %s %s", port, stopPort);
        } else {
            startCommand = startCommand.replaceFirst(DEFAULT_PORT, String.valueOf(port));
            startCommand = startCommand.replaceFirst(DEFAULT_STOPPORT, String.valueOf(stopPort));
            startCommand = startCommand.replaceFirst(DEFAULT_RMIPORT, String.valueOf(rmiPort));
        }
        return startCommand;
    }

    private String getDefaultStopCommand(int stopPort) {
        String stopCommand = STOP_COMMAND;
        stopCommand = stopCommand == null ? (SystemUtils.IS_OS_WINDOWS ? String.format("cmd /c stop_xwiki.bat %s", stopPort) : String.format("sh -f stop_xwiki.sh %s", stopPort)) : stopCommand.replaceFirst(DEFAULT_STOPPORT, String.valueOf(stopPort));
        return stopCommand;
    }

    private class Response {
        public boolean timedOut;
        public byte[] responseBody;
        public int responseCode;

        private Response() {
        }
    }
}

