/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;

public class ChangesPane
extends BaseElement {
    @FindBy(id="changescontent")
    private WebElement container;
    @FindBy(id="changes-info-box-from")
    private WebElement fromVersionSummary;
    @FindBy(id="changes-info-box-to")
    private WebElement toVersionSummary;
    @FindBy(id="changes-info-comment")
    private WebElement changeComment;

    public String getFromVersionSummary() {
        return this.fromVersionSummary.getText();
    }

    public String getToVersionSummary() {
        return this.toVersionSummary.getText();
    }

    public String getChangeComment() {
        return this.changeComment.getText();
    }

    public List<String> getChangedMetaData() {
        By xpath = By.xpath((String)"dl[preceding-sibling::*[1][. = 'Metadata changes']]/dt");
        return this.getText(ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, xpath));
    }

    public String getMetaDataChanges(String propertyLabel) {
        String xpath = ".//dd[preceding-sibling::dt[1][. = '" + propertyLabel + "'] and " + "parent::dl[preceding-sibling::*[1][. = 'Metadata changes']]]/*[1]";
        return this.getDiff(ChangesPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, By.xpath((String)xpath)));
    }

    private String getDiff(WebElement element) {
        if ("diff-line".equals(element.getAttribute("class"))) {
            return (String)this.executeJavascript("return arguments[0].innerHTML", element);
        }
        By xpath = By.xpath((String)".//td[3]");
        StringBuilder diff = new StringBuilder();
        for (WebElement line : ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), element, xpath)) {
            if (diff.length() > 0) {
                diff.append('\n');
            }
            if (ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), line, By.tagName((String)"ins")).size() > 0 || ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), line, By.tagName((String)"del")).size() > 0) {
                diff.append(this.executeJavascript("return arguments[0].innerHTML", line));
                continue;
            }
            diff.append(line.getText());
        }
        return diff.toString();
    }

    public String getContentChanges() {
        By xpath = By.xpath((String)"div[@class = 'diff-container' and preceding-sibling::*[1][. = 'Content changes']]");
        List<WebElement> found = ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, xpath);
        return found.size() > 0 ? this.getDiff(found.get(0)) : null;
    }

    public List<String> getAttachmentChanges() {
        By xpath = By.xpath((String)"ul[preceding-sibling::*[1][. = 'Attachment changes']]/li");
        return this.getText(ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, xpath));
    }

    public String getCommentChanges(int commentNumber, String propertyLabel) {
        String xpath = ".//dd[preceding-sibling::dt[1][. = '" + propertyLabel + "'] and " + "parent::dl[preceding-sibling::*[1][starts-with(., 'Comment number " + commentNumber + "')]]]/*[1]";
        return this.getDiff(ChangesPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, By.xpath((String)xpath)));
    }

    public List<String> getCommentChangeSummaries() {
        By xpath = By.xpath((String)"*[starts-with(name(), 'H') and starts-with(., 'Comment number ')]");
        return this.getText(ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, xpath));
    }

    public String getObjectChanges(String objectType, int objectNumber, String propertyLabel) {
        String xpath = ".//dd[preceding-sibling::dt[1][. = '" + propertyLabel + "'] and " + "parent::dl[preceding-sibling::*[1][starts-with(., 'Object number " + objectNumber + " of type " + objectType + "')]]]/*[1]";
        return this.getDiff(ChangesPane.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, By.xpath((String)xpath)));
    }

    public List<String> getObjectChangeSummaries() {
        By xpath = By.xpath((String)"*[starts-with(name(), 'H') and starts-with(., 'Object number ')]");
        return this.getText(ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, xpath));
    }

    public List<String> getClassChanges() {
        By xpath = By.xpath((String)"ul[preceding-sibling::*[1][. = 'Class changes']]/li");
        return this.getText(ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, xpath));
    }

    private List<String> getText(List<WebElement> elements) {
        ArrayList<String> text = new ArrayList<String>();
        for (WebElement element : elements) {
            text.add(element.getText());
        }
        return text;
    }

    public boolean hasNoChanges() {
        return ChangesPane.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, By.xpath((String)"div[@class = 'infomessage' and . = 'No changes']")).size() > 0;
    }
}

