/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.ui.po;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.LiveTableElement;

public class EditRightsPane
extends BaseElement {
    private LiveTableElement rightsTable;
    @FindBy(id="uorgu")
    private WebElement showUsersField;
    @FindBy(id="uorgg")
    private WebElement showGroupsField;

    public void switchToUsers() {
        this.showUsersField.click();
        this.getRightsTable().waitUntilReady();
    }

    public void switchToGroups() {
        this.showGroupsField.click();
        this.getRightsTable().waitUntilReady();
    }

    public State getGuestRight(Right right) {
        By iconLocator = By.xpath((String)("//tr[@id='unregistered']/td[" + right.getColumnIndex() + "]/img"));
        WebElement icon = this.getDriver().findElement(iconLocator);
        return State.getButtonState(icon);
    }

    public State getRight(String entityName, Right right) {
        By iconLocator = By.xpath((String)("//*[@id='usersandgroupstable-display']//td[@class='username']/a[contains(@href, '" + entityName + "')]/../../td[" + right.getColumnIndex() + "]/img"));
        WebElement icon = this.getDriver().findElement(iconLocator);
        return State.getButtonState(icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clickGuestRight(Right right) {
        try {
            this.executeJavascript("window.__oldConfirm = window.confirm; window.confirm = function() { return true; };", new Object[0]);
            By buttonLocator = By.xpath((String)("*//tr[@id='unregistered']/td[" + right.getColumnIndex() + "]/img"));
            WebElement button = this.getDriver().findElement(buttonLocator);
            State currentState = State.getButtonState(button);
            button.click();
            this.waitUntilElementEndsWithAttributeValue(buttonLocator, "src", currentState.getNextState().imageURL);
        }
        finally {
            this.executeJavascript("window.confirm = window.__oldConfirm;", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clickRight(String entityName, Right right) {
        try {
            this.executeJavascript("window.__oldConfirm = window.confirm; window.confirm = function() { return true; };", new Object[0]);
            By buttonLocator = By.xpath((String)("//*[@id='usersandgroupstable-display']//td[@class='username']/a[contains(@href, '" + entityName + "')]/../../td[" + right.getColumnIndex() + "]/img"));
            WebElement button = this.getDriver().findElement(buttonLocator);
            State currentState = State.getButtonState(button).getNextState();
            button.click();
            this.waitUntilElementEndsWithAttributeValue(buttonLocator, "src", currentState.imageURL);
        }
        finally {
            this.executeJavascript("window.confirm = window.__oldConfirm;", new Object[0]);
        }
    }

    public void setRight(String entityName, Right right, State wantedState) {
        while (this.getRight(entityName, right) != wantedState) {
            this.clickRight(entityName, right);
        }
    }

    public void setGuestRight(Right right, State wantedState) {
        while (this.getGuestRight(right) != wantedState) {
            this.clickGuestRight(right);
        }
    }

    public String getURL(String space, String page) {
        return EditRightsPane.getUtil().getURL(space, page, "edit", "editor=rights");
    }

    protected LiveTableElement getRightsTable() {
        if (this.rightsTable == null) {
            this.rightsTable = new LiveTableElement("usersandgroupstable");
            this.rightsTable.waitUntilReady();
        }
        return this.rightsTable;
    }

    public static enum State {
        NONE("/xwiki/resources/js/xwiki/usersandgroups/img/none.png"),
        ALLOW("/xwiki/resources/js/xwiki/usersandgroups/img/allow.png"),
        DENY("/xwiki/resources/js/xwiki/usersandgroups/img/deny1.png");

        String imageURL;

        private State(String imageURL) {
            this.imageURL = imageURL;
        }

        State getNextState() {
            return State.values()[(this.ordinal() + 1) % State.values().length];
        }

        static State getButtonState(WebElement button) {
            for (State s : State.values()) {
                if (!button.getAttribute("src").endsWith(s.imageURL)) continue;
                return s;
            }
            return NONE;
        }
    }

    public static enum Right {
        VIEW,
        COMMENT,
        EDIT,
        DELETE,
        ADMIN,
        REGISTER,
        PROGRAM;


        int getColumnIndex() {
            return this.ordinal() + 2;
        }
    }
}

